/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.alfsteel;

import de.melanx.aiotbotania.compat.MythicBotanyCompat;
import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.util.ToolSet;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;

public class RecipeAlfsteelAIOT
extends CustomRecipe {
    public static final NoOpRecipeSerializer<RecipeAlfsteelAIOT> SERIALIZER = new NoOpRecipeSerializer(RecipeAlfsteelAIOT::new);
    public static final ToolSet TOOL_SET = MythicBotanyCompat.isLoaded() ? MythicBotanyCompat.alfsteelToolset() : new ToolSet(Items.f_42420_, Items.f_42423_, Items.f_42422_, Items.f_42421_, Items.f_42424_);

    public RecipeAlfsteelAIOT(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        boolean foundSword = false;
        boolean foundAxe = false;
        boolean foundPick = false;
        boolean foundShovel = false;
        boolean foundHoe = false;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack stack = inv.m_8020_(j);
            if (stack.m_41619_()) continue;
            if (TOOL_SET.testSword(stack) && !foundSword) {
                foundSword = true;
                continue;
            }
            if (TOOL_SET.testAxe(stack) && !foundAxe) {
                foundAxe = true;
                continue;
            }
            if (TOOL_SET.testPickaxe(stack) && !foundPick) {
                foundPick = true;
                continue;
            }
            if (TOOL_SET.testShovel(stack) && !foundShovel) {
                foundShovel = true;
                continue;
            }
            if (TOOL_SET.testHoe(stack) && !foundHoe) {
                foundHoe = true;
                continue;
            }
            return false;
        }
        return foundSword && foundAxe && foundPick && foundShovel && foundHoe;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess registryAccess) {
        ItemStack stack = new ItemStack((ItemLike)Registration.alfsteel_aiot.get());
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack ingredient = inv.m_8020_(j);
            if (ingredient.m_41619_() || !TOOL_SET.testPickaxe(ingredient)) continue;
            stack.m_41751_(ingredient.m_41784_().m_6426_());
        }
        return stack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 3;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

