/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.alfsteel;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.melanx.aiotbotania.compat.MythicBotany;
import de.melanx.aiotbotania.items.ItemTiers;
import de.melanx.aiotbotania.items.alfsteel.ModPylonRepairable;
import de.melanx.aiotbotania.items.terrasteel.ItemTerraSteelAIOT;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fml.ModList;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.common.entity.ManaBurstEntity;

public class ItemAlfsteelAIOT
extends ItemTerraSteelAIOT
implements MythicBotany,
ModPylonRepairable,
LensEffectItem {
    public static final int MANA_PER_DAMAGE = 200;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ItemAlfsteelAIOT() {
        super(ItemTiers.ALFSTEEL_AIOT_ITEM_TIER);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_41008_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", 2.2, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    @Override
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        if (player.m_6144_()) {
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            if (!level.f_46443_) {
                ItemStack stack = player.m_21120_(hand);
                stack.m_41622_(1, (LivingEntity)player, _x -> {});
                player.m_21008_(hand, stack);
            }
            int ITEM_COLLECT_RANGE = 8;
            List items = level.m_45976_(ItemEntity.class, new AABB(x - (double)ITEM_COLLECT_RANGE, y - (double)ITEM_COLLECT_RANGE, z - (double)ITEM_COLLECT_RANGE, x + (double)ITEM_COLLECT_RANGE, y + (double)ITEM_COLLECT_RANGE, z + (double)ITEM_COLLECT_RANGE));
            for (ItemEntity item : items) {
                item.m_7678_(x + (double)level.f_46441_.m_188501_() - 0.5, y + (double)level.f_46441_.m_188501_(), z + (double)level.f_46441_.m_188501_() - 0.5, item.f_19857_, item.f_19858_);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    @Override
    public ManaBurstEntity getBurst(Player player, ItemStack stack) {
        ManaBurstEntity burst = super.getBurst(player, stack);
        if (burst != null) {
            burst.setColor(16224512);
            burst.setMana(ItemAlfsteelAIOT.getManaPerDamage());
            burst.setStartingMana(ItemAlfsteelAIOT.getManaPerDamage());
            burst.setMinManaLoss(20);
            burst.setManaLossPerTick(2.0f);
        }
        return burst;
    }

    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        AABB aabb = new AABB(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82400_(1.0);
        Entity thrower = entity.m_19749_();
        List entities = entity.m_9236_().m_45976_(LivingEntity.class, aabb);
        for (LivingEntity living : entities) {
            int mana;
            if (living == thrower) continue;
            if (living instanceof Player) {
                Player throwingPlayer;
                Player livingPlayer = (Player)living;
                if (thrower instanceof Player && !(throwingPlayer = (Player)thrower).m_7099_(livingPlayer)) continue;
            }
            if (living.f_20916_ != 0 || (mana = burst.getMana()) < 33) continue;
            burst.setMana(mana - 33);
            float damage = 4.0f + this.m_41008_();
            Level level = entity.m_9236_();
            if (burst.isFake() || level.f_46443_) continue;
            DamageSource source = level.m_269111_().m_269425_();
            if (thrower instanceof Player) {
                Player player = (Player)thrower;
                source = level.m_269111_().m_269075_(player);
            } else if (thrower instanceof LivingEntity) {
                LivingEntity livingThrower = (LivingEntity)thrower;
                source = level.m_269111_().m_269333_(livingThrower);
            }
            living.m_6469_(source, damage);
            if (burst.getMana() > 0) continue;
            entity.m_146870_();
        }
    }

    public static int getManaPerDamage() {
        return 200;
    }

    public float m_41008_() {
        return 12.0f;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean canRepairPylon(ItemStack stack) {
        return stack.m_41773_() > 0;
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return 500;
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.m_41721_(Math.max(0, stack.m_41773_() - 5));
        return stack;
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (!ModList.get().isLoaded("mythicbotany")) {
            tooltip.add((Component)Component.m_237115_((String)"aiotbotania.mythicbotany.disabled").m_130940_(ChatFormatting.DARK_RED));
        } else {
            super.m_7373_(stack, level, tooltip, flag);
        }
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props, Level level) {
    }

    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        return shouldKill;
    }

    @Override
    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        return true;
    }

    @Override
    public boolean m_245993_(@Nonnull FeatureFlagSet enabledFeatures) {
        return super.m_245993_(enabledFeatures) && ModList.get().isLoaded("mythicbotany");
    }
}

