/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.terrasteel;

import de.melanx.aiotbotania.core.Registration;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;

public class RecipeTerraSteelAIOTTipped
extends CustomRecipe {
    public static final NoOpRecipeSerializer<RecipeTerraSteelAIOTTipped> SERIALIZER = new NoOpRecipeSerializer(RecipeTerraSteelAIOTTipped::new);
    private static final Ingredient INGREDIENT_TERRA = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.terrasteel_aiot.get()});
    private static final Ingredient INGREDIENT_ELEMENTIUM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.elementiumPick});

    public RecipeTerraSteelAIOTTipped(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level level) {
        boolean foundTerra = false;
        boolean foundElementium = false;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack stack = inv.m_8020_(j);
            if (stack.m_41619_()) continue;
            if (INGREDIENT_TERRA.test(stack) && !foundTerra && !ItemNBTHelper.getBoolean((ItemStack)stack, (String)"tipped", (boolean)false)) {
                foundTerra = true;
                continue;
            }
            if (INGREDIENT_ELEMENTIUM.test(stack) && !foundElementium) {
                foundElementium = true;
                continue;
            }
            return false;
        }
        return foundTerra && foundElementium;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess registryAccess) {
        ItemStack stack = new ItemStack((ItemLike)Registration.terrasteel_aiot.get());
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack ingredient = inv.m_8020_(j);
            if (ingredient.m_41619_() || !INGREDIENT_TERRA.test(ingredient)) continue;
            stack.m_41751_(ingredient.m_41784_().m_6426_());
        }
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"tipped", (boolean)true);
        return stack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 3;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        ItemStack stack = new ItemStack((ItemLike)Registration.terrasteel_aiot.get());
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"tipped", (boolean)true);
        return stack;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

