/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.alfsteel;

import de.melanx.aiotbotania.core.Registration;
import javax.annotation.Nonnull;
import mythicbotany.register.ModItems;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;

public class RecipeAlfsteelAIOT
extends CustomRecipe {
    public static final NoOpRecipeSerializer<RecipeAlfsteelAIOT> SERIALIZER = new NoOpRecipeSerializer(RecipeAlfsteelAIOT::new);
    private static final Ingredient INGREDIENT_SWORD = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.alfsteelSword});
    private static final Ingredient INGREDIENT_AXE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.alfsteelAxe});
    private static final Ingredient INGREDIENT_PICK = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.alfsteelPick});
    private static final Ingredient INGREDIENT_SHOVEL = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.alfsteel_shovel.get()});
    private static final Ingredient INGREDIENT_HOE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.alfsteel_hoe.get()});

    public RecipeAlfsteelAIOT(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        boolean foundSword = false;
        boolean foundAxe = false;
        boolean foundPick = false;
        boolean foundShovel = false;
        boolean foundHoe = false;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack stack = inv.m_8020_(j);
            if (stack.m_41619_()) continue;
            if (INGREDIENT_SWORD.test(stack) && !foundSword) {
                foundSword = true;
                continue;
            }
            if (INGREDIENT_AXE.test(stack) && !foundAxe) {
                foundAxe = true;
                continue;
            }
            if (INGREDIENT_PICK.test(stack) && !foundPick) {
                foundPick = true;
                continue;
            }
            if (INGREDIENT_SHOVEL.test(stack) && !foundShovel) {
                foundShovel = true;
                continue;
            }
            if (INGREDIENT_HOE.test(stack) && !foundHoe) {
                foundHoe = true;
                continue;
            }
            return false;
        }
        return foundSword && foundAxe && foundPick && foundShovel && foundHoe;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess registryAccess) {
        ItemStack stack = new ItemStack((ItemLike)Registration.alfsteel_aiot.get());
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack ingredient = inv.m_8020_(j);
            if (ingredient.m_41619_() || !INGREDIENT_PICK.test(ingredient)) continue;
            stack.m_41751_(ingredient.m_41784_().m_6426_());
        }
        return stack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 3;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

