/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.recipe.brewery;

import de.melanx.utilitix.recipe.PotionInput;
import de.melanx.utilitix.recipe.PotionOutput;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;

public abstract class EffectTransformer {
    protected EffectTransformer() {
    }

    public abstract boolean canTransform(PotionInput var1);

    public abstract ItemStack output();

    @Nullable
    public abstract PotionOutput transform(PotionInput var1);

    public List<MobEffectInstance> getEffects(PotionContents contents) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        contents.getAllEffects().forEach(effects::add);
        return effects;
    }

    public static ItemStack create(Item item, @Nullable List<MobEffectInstance> effects) {
        ItemStack stack = new ItemStack((ItemLike)item);
        PotionContents contents = new PotionContents(Potions.AWKWARD);
        if (effects != null && !effects.isEmpty()) {
            for (MobEffectInstance effect : effects) {
                contents = contents.withEffectAdded(new MobEffectInstance(effect));
            }
        }
        stack.set(DataComponents.POTION_CONTENTS, (Object)contents);
        return stack;
    }
}

