/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.recipe.brewery;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.utilitix.recipe.PotionInput;
import de.melanx.utilitix.recipe.PotionOutput;
import de.melanx.utilitix.recipe.brewery.EffectTransformer;
import de.melanx.utilitix.registration.ModItemTags;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import org.moddingx.libx.util.Misc;

public class Apply
extends EffectTransformer {
    public static final Codec<Holder<MobEffect>> MOB_EFFECT_HOLDER_CODEC = ResourceLocation.CODEC.comapFlatMap(id -> BuiltInRegistries.MOB_EFFECT.getHolder(id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown mob effect: " + String.valueOf(id))), holder -> {
        ResourceLocation key = BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)holder.value()));
        return key == null ? Misc.MISSINGNO : key;
    });
    public static final Codec<MobEffectInstance> EFFECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MOB_EFFECT_HOLDER_CODEC.fieldOf("effect").forGetter(MobEffectInstance::getEffect), (App)Codec.intRange((int)1, (int)255).optionalFieldOf("amplifier", (Object)1).forGetter(e -> e.getAmplifier() + 1), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("duration").forGetter(MobEffectInstance::getDuration), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(MobEffectInstance::isAmbient), (App)Codec.BOOL.optionalFieldOf("particles", (Object)true).forGetter(MobEffectInstance::isVisible)).apply((Applicative)instance, (effect, ampPlusOne, duration, ambient, particles) -> new MobEffectInstance(effect, duration.intValue(), Math.max(0, ampPlusOne - 1), ambient.booleanValue(), particles.booleanValue())));
    public static final MapCodec<Apply> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(Apply::getName), (App)EFFECT_CODEC.listOf().fieldOf("effects").forGetter(Apply::getEffects)).apply((Applicative)instance, (nameOpt, effects) -> new Apply((Component)nameOpt.orElse(null), (List<MobEffectInstance>)effects)));
    public static final StreamCodec<RegistryFriendlyByteBuf, Apply> STREAM_CODEC = StreamCodec.of(Apply::toNetwork, Apply::fromNetwork);
    @Nullable
    private final Component name;
    private final List<MobEffectInstance> effects;

    public Apply(MobEffectInstance ... effects) {
        this((Component)null, effects);
    }

    public Apply(List<MobEffectInstance> effects) {
        this(null, effects);
    }

    public Apply(@Nullable Component name, MobEffectInstance ... effects) {
        this(name, (List<MobEffectInstance>)ImmutableList.copyOf((Object[])effects));
    }

    public Apply(@Nullable Component name, List<MobEffectInstance> effects) {
        this.name = name;
        this.effects = ImmutableList.copyOf(effects);
    }

    @Override
    public boolean canTransform(PotionInput input) {
        return input.getMain().is(ModItemTags.POTIONS) && input.testEffectsMain(contents -> this.getEffects((PotionContents)contents).isEmpty()) && input.getIn1().isEmpty() && input.getIn2().isEmpty();
    }

    @Override
    public ItemStack output() {
        ItemStack stack = EffectTransformer.create(Items.POTION, this.effects);
        if (this.name != null) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.name.copy());
        }
        return stack;
    }

    @Override
    @Nullable
    public PotionOutput transform(PotionInput input) {
        ItemStack stack = EffectTransformer.create(input.getMain().getItem(), this.effects);
        if (this.name != null) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.name.copy());
        }
        return PotionOutput.simple(stack);
    }

    @Nullable
    public Optional<Component> getName() {
        return Optional.ofNullable(this.name);
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    private static Apply fromNetwork(RegistryFriendlyByteBuf buffer) {
        Component name = null;
        if (buffer.readBoolean()) {
            name = (Component)ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC.decode((Object)buffer);
        }
        int size = buffer.readVarInt();
        ImmutableList.Builder effects = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            CompoundTag nbt = buffer.readNbt();
            if (nbt == null) {
                throw new IllegalStateException("Missing MobEffectInstance NBT in Apply transformer");
            }
            effects.add((Object)Objects.requireNonNull(MobEffectInstance.load((CompoundTag)nbt)));
        }
        return new Apply(name, (List<MobEffectInstance>)effects.build());
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, Apply transformer) {
        buffer.writeBoolean(transformer.name != null);
        if (transformer.name != null) {
            ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC.encode((Object)buffer, (Object)transformer.name);
        }
        buffer.writeVarInt(transformer.effects.size());
        for (MobEffectInstance effect : transformer.effects) {
            buffer.writeNbt(effect.save());
        }
    }
}

