/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.network.handler;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.glue.StickyChunk;
import de.melanx.utilitix.network.handler.StickyChunkUpdate;
import de.melanx.utilitix.registration.ModAttachmentTypes;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class StickyChunkRequest
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(UtilitiX.getInstance().resource("sticky_chunk_request"));

    public StickyChunkRequest() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        if (!sender.level().hasChunkAt(new BlockPos(msg.pos().getMinBlockX(), 0, msg.pos().getMinBlockZ()))) {
            return;
        }
        LevelChunk chunk = sender.level().getChunk(msg.pos().x, msg.pos().z);
        if (chunk != null && chunk.loaded) {
            Optional stickyChunk = chunk.getExistingData(ModAttachmentTypes.stickyChunk);
            stickyChunk.ifPresent(value -> PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)new StickyChunkUpdate.Message(msg.pos(), (StickyChunk)value), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public record Message(ChunkPos pos) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeInt(msg.pos.x);
            buffer.writeInt(msg.pos.z);
        }, buffer -> new Message(new ChunkPos(buffer.readInt(), buffer.readInt())));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

