/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.mixin;

import de.melanx.utilitix.content.glue.StickyChunk;
import de.melanx.utilitix.registration.ModAttachmentTypes;
import de.melanx.utilitix.util.MixinUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PistonMovingBlockEntity.class})
public class MixinPistonMovingBlockEntity {
    @Unique
    private Byte utilitiX$glueData;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private static void tick(Level level, BlockPos pos, BlockState state, PistonMovingBlockEntity blockEntity, CallbackInfo ci) {
        if (((MixinPistonMovingBlockEntity)blockEntity).utilitiX$glueData != null) {
            return;
        }
        BlockPos fromPos = pos.relative(blockEntity.isExtending() ? blockEntity.getDirection().getOpposite() : blockEntity.getDirection());
        LevelChunk chunk = level.getChunkAt(fromPos);
        StickyChunk glue = (StickyChunk)chunk.getExistingDataOrNull(ModAttachmentTypes.stickyChunk);
        if (glue == null) {
            return;
        }
        int x = fromPos.getX() & 0xF;
        int y = fromPos.getY();
        int z = fromPos.getZ() & 0xF;
        ((MixinPistonMovingBlockEntity)blockEntity).utilitiX$glueData = glue.getData(x, y, z);
        glue.clearData(x, y, z);
        chunk.setUnsaved(true);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift=At.Shift.AFTER)})
    private static void afterSetBlockState(Level level, BlockPos pos, BlockState state, PistonMovingBlockEntity blockEntity, CallbackInfo ci) {
        MixinUtil.afterSetBlockState(level, pos, ((MixinPistonMovingBlockEntity)blockEntity).utilitiX$glueData);
    }

    @Inject(method={"finalTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift=At.Shift.AFTER)})
    public void afterSetBlockState(CallbackInfo ci) {
        PistonMovingBlockEntity blockEntity = (PistonMovingBlockEntity)this;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        MixinUtil.afterSetBlockState(level, pos, this.utilitiX$glueData);
    }

    @Inject(method={"loadAdditional"}, at={@At(value="RETURN")})
    public void read(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        if (tag.contains("utilitix_glue_data", 99)) {
            this.utilitiX$glueData = tag.getByte("utilitix_glue_data");
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    public void write(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        if (this.utilitiX$glueData != null) {
            tag.putByte("utilitix_glue_data", this.utilitiX$glueData.byteValue());
        }
    }
}

