/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.data;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.data.recipe.BreweryRecipeBuilder;
import de.melanx.utilitix.recipe.brewery.Apply;
import de.melanx.utilitix.recipe.brewery.Clone;
import de.melanx.utilitix.recipe.brewery.Merge;
import de.melanx.utilitix.recipe.brewery.Upgrade;
import de.melanx.utilitix.registration.ModBlocks;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModRegisterables;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.recipe.RecipeProviderBase;
import org.moddingx.libx.datagen.provider.recipe.StoneCuttingExtension;
import org.moddingx.libx.datagen.provider.recipe.crafting.CraftingExtension;

public class RecipeProvider
extends RecipeProviderBase
implements CraftingExtension,
StoneCuttingExtension {
    public RecipeProvider(DatagenContext context) {
        super(context);
    }

    protected void setup() {
        this.removeNbt((ItemLike)ModItems.linkedCrystal);
        this.createTinyCoalRecipe((ItemLike)Items.COAL, (ItemLike)ModItems.tinyCoal);
        this.createTinyCoalRecipe((ItemLike)Items.CHARCOAL, (ItemLike)ModItems.tinyCharcoal);
        this.createBellRecipes();
        this.createMiscRecipes();
        this.createRedstoneRecipes();
        this.createBreweryRecipes();
        this.createRailRecipes();
        this.createCartRecipes();
        this.createShearsRecipes();
        this.createBoatRecipes();
        this.wall((ItemLike)ModBlocks.stoneWall, Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}));
        this.shaped(new Object[]{ModItems.mobYoinker, "CIC", "ILI", "III", Character.valueOf('I'), Items.IRON_BARS, Character.valueOf('C'), Items.COPPER_INGOT, Character.valueOf('L'), Items.LEAD});
        this.shaped(new Object[]{ModBlocks.dimmableRedstoneLamp, 4, " L ", "LRL", " L ", Character.valueOf('L'), Blocks.REDSTONE_LAMP, Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE});
        this.shapeless(new Object[]{UtilitiX.getInstance().resource(BuiltInRegistries.BLOCK.getKey((Object)Blocks.REDSTONE_LAMP).getPath() + "_revert"), Blocks.REDSTONE_LAMP, ModBlocks.dimmableRedstoneLamp});
    }

    private void createTinyCoalRecipe(ItemLike coal, ItemLike tinyCoal) {
        this.shapeless(new Object[]{this.loc(tinyCoal, "to_tiny"), tinyCoal, 8, coal});
        this.shapeless(new Object[]{this.loc(tinyCoal, "from_tiny"), coal, tinyCoal, tinyCoal, tinyCoal, tinyCoal, tinyCoal, tinyCoal, tinyCoal, tinyCoal});
    }

    private void createBellRecipes() {
        this.shaped(new Object[]{ModItems.handBell, " s", "sb", Character.valueOf('s'), Tags.Items.RODS_WOODEN, Character.valueOf('b'), Items.BELL});
        this.shaped(new Object[]{ModItems.mobBell, "abc", "def", "ghi", Character.valueOf('a'), Items.SPIDER_EYE, Character.valueOf('b'), Items.GHAST_TEAR, Character.valueOf('c'), Tags.Items.BONES, Character.valueOf('d'), Tags.Items.GUNPOWDERS, Character.valueOf('e'), ModItems.handBell, Character.valueOf('f'), Tags.Items.DUSTS_GLOWSTONE, Character.valueOf('g'), Items.BLAZE_POWDER, Character.valueOf('h'), Tags.Items.ENDER_PEARLS, Character.valueOf('i'), Items.ROTTEN_FLESH});
    }

    private void createMiscRecipes() {
        this.shaped(new Object[]{ModItems.armedStand, "sas", Character.valueOf('a'), Items.ARMOR_STAND, Character.valueOf('s'), Tags.Items.RODS_WOODEN});
        this.shaped(new Object[]{ModItems.gildingCrystal, " g ", "gmg", " g ", Character.valueOf('g'), Tags.Items.INGOTS_GOLD, Character.valueOf('m'), Items.PHANTOM_MEMBRANE});
        this.shapeless(new Object[]{ModItems.glueBall, 4, Tags.Items.SLIME_BALLS, Tags.Items.SLIME_BALLS});
        this.shaped(new Object[]{ModBlocks.experienceCrystal, "geg", "exe", "ccc", Character.valueOf('g'), Blocks.LIME_STAINED_GLASS, Character.valueOf('e'), Tags.Items.GEMS_EMERALD, Character.valueOf('x'), Items.EXPERIENCE_BOTTLE, Character.valueOf('c'), Items.BLACK_CONCRETE});
        this.shaped(new Object[]{ModBlocks.crudeFurnace, "C C", "SFS", "SSS", Character.valueOf('C'), Tags.Items.STONES, Character.valueOf('S'), Tags.Items.COBBLESTONES, Character.valueOf('F'), Items.FURNACE});
        this.shaped(new Object[]{ModItems.quiver, "RLR", "LSL", "RLR", Character.valueOf('R'), Items.RABBIT_HIDE, Character.valueOf('L'), Tags.Items.LEATHERS, Character.valueOf('S'), Tags.Items.STRINGS});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.quiver, "rotated"), ModItems.quiver, "LRL", "RSR", "LRL", Character.valueOf('R'), Items.RABBIT_HIDE, Character.valueOf('L'), Tags.Items.LEATHERS, Character.valueOf('S'), Tags.Items.STRINGS});
    }

    private void createRedstoneRecipes() {
        this.shaped(new Object[]{ModBlocks.weakRedstoneTorch, 2, "R", "S", "S", Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE, Character.valueOf('S'), Tags.Items.RODS_WOODEN});
        this.shaped(new Object[]{ModBlocks.comparatorRedirectorUp, "sis", "s s", "sts", Character.valueOf('t'), Items.REDSTONE_TORCH, Character.valueOf('s'), Tags.Items.COBBLESTONES, Character.valueOf('i'), Tags.Items.INGOTS_IRON});
        this.shaped(new Object[]{ModBlocks.comparatorRedirectorDown, "sts", "s s", "sis", Character.valueOf('t'), Items.REDSTONE_TORCH, Character.valueOf('s'), Tags.Items.COBBLESTONES, Character.valueOf('i'), Tags.Items.INGOTS_IRON});
        this.shapeless(new Object[]{this.loc((ItemLike)ModBlocks.comparatorRedirectorUp, "flip"), ModBlocks.comparatorRedirectorUp, ModBlocks.comparatorRedirectorDown});
        this.shapeless(new Object[]{this.loc((ItemLike)ModBlocks.comparatorRedirectorDown, "flip"), ModBlocks.comparatorRedirectorDown, ModBlocks.comparatorRedirectorUp});
        this.shaped(new Object[]{ModItems.linkedCrystal, " r ", "rgr", " r ", Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE, Character.valueOf('g'), Tags.Items.GEMS_EMERALD});
        this.shaped(new Object[]{ModBlocks.linkedRepeater, "r t", "sss", Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE, Character.valueOf('t'), Items.REDSTONE_TORCH, Character.valueOf('s'), Tags.Items.STONES});
    }

    private void createBreweryRecipes() {
        this.shaped(new Object[]{ModBlocks.advancedBrewery, " g ", "isi", "bbb", Character.valueOf('s'), Items.BREWING_STAND, Character.valueOf('b'), Items.SMOOTH_STONE, Character.valueOf('i'), Tags.Items.INGOTS_IRON, Character.valueOf('g'), Tags.Items.INGOTS_GOLD});
        BreweryRecipeBuilder.breweryRecipe().input((ItemLike)Items.GOLDEN_APPLE).action(new Apply((Component)Component.translatable((String)("item." + UtilitiX.getInstance().modid + ".apple_juice")).withStyle(ChatFormatting.GREEN), new MobEffectInstance(MobEffects.REGENERATION, 100, 1), new MobEffectInstance(MobEffects.ABSORPTION, 2400, 0))).save(this.output(), ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"apple_juice"));
        BreweryRecipeBuilder.breweryRecipe().input((ItemLike)Items.ENCHANTED_GOLDEN_APPLE).action(new Apply((Component)Component.translatable((String)("item." + UtilitiX.getInstance().modid + ".god_apple_juice")).withStyle(ChatFormatting.GREEN), new MobEffectInstance(MobEffects.REGENERATION, 400, 1), new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 6000, 0), new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 6000, 0), new MobEffectInstance(MobEffects.ABSORPTION, 2400, 3))).save(this.output(), ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"god_apple_juice"));
        BreweryRecipeBuilder.breweryRecipe().action(new Merge(1.0f)).save(this.output(), ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"merge"));
        BreweryRecipeBuilder.breweryRecipe().input((ItemLike)Items.NETHERITE_SCRAP).action(new Clone()).save(this.output(), ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"clone"));
        BreweryRecipeBuilder.breweryRecipe().input((ItemLike)Items.POPPED_CHORUS_FRUIT).action(new Upgrade(2)).save(this.output(), ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"upgrade"));
    }

    private void createRailRecipes() {
        this.shaped(new Object[]{ModBlocks.highspeedRail, 3, "e e", "ese", "ere", Character.valueOf('e'), Tags.Items.GEMS_EMERALD, Character.valueOf('s'), Tags.Items.RODS_WOODEN, Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE});
        this.shaped(new Object[]{ModBlocks.directionalRail, 6, "gig", "gsg", "grg", Character.valueOf('g'), Tags.Items.INGOTS_GOLD, Character.valueOf('s'), Tags.Items.RODS_WOODEN, Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE, Character.valueOf('i'), Tags.Items.NUGGETS_IRON});
        this.shaped(new Object[]{ModBlocks.directionalHighspeedRail, 3, "eie", "ese", "ere", Character.valueOf('e'), Tags.Items.GEMS_EMERALD, Character.valueOf('s'), Tags.Items.RODS_WOODEN, Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE, Character.valueOf('i'), Tags.Items.NUGGETS_IRON});
        this.shaped(new Object[]{ModBlocks.crossingRail, 4, " r ", "rrr", " r ", Character.valueOf('r'), Items.RAIL});
        this.shaped(new Object[]{ModBlocks.filterRail, 2, "r ", "nr", "r ", Character.valueOf('r'), Items.RAIL, Character.valueOf('n'), Tags.Items.NUGGETS_IRON});
        this.shaped(new Object[]{ModItems.minecartTinkerer, " nm", " in", "i  ", Character.valueOf('i'), Tags.Items.INGOTS_IRON, Character.valueOf('n'), Tags.Items.NUGGETS_IRON, Character.valueOf('m'), Items.MINECART});
        this.shaped(new Object[]{ModBlocks.reinforcedRail, 16, "i i", "lsl", "i i", Character.valueOf('i'), Tags.Items.INGOTS_IRON, Character.valueOf('l'), Tags.Items.GEMS_LAPIS, Character.valueOf('s'), Tags.Items.RODS_WOODEN});
        this.shaped(new Object[]{ModBlocks.reinforcedCrossingRail, 4, " r ", "rrr", " r ", Character.valueOf('r'), ModBlocks.reinforcedRail});
        this.shaped(new Object[]{ModBlocks.reinforcedFilterRail, 2, "r ", "nr", "r ", Character.valueOf('r'), ModBlocks.reinforcedRail, Character.valueOf('n'), Tags.Items.NUGGETS_IRON});
        this.controllerRail((ItemLike)ModBlocks.pistonControllerRail, (ItemLike)ModBlocks.reinforcedPistonControllerRail, (ItemLike)ModRegisterables.pistonCart.item());
    }

    private void controllerRail(ItemLike rail, ItemLike reinforcedRail, ItemLike cart) {
        this.shaped(new Object[]{rail, 8, "rar", "aca", "rar", Character.valueOf('a'), Items.ACTIVATOR_RAIL, Character.valueOf('r'), Items.RAIL, Character.valueOf('c'), cart});
        this.shaped(new Object[]{reinforcedRail, 8, "rar", "aca", "rar", Character.valueOf('a'), Items.ACTIVATOR_RAIL, Character.valueOf('r'), ModBlocks.reinforcedRail, Character.valueOf('c'), cart});
    }

    private void createCartRecipes() {
        this.cart((ItemLike)ModRegisterables.enderCart.item(), (ItemLike)Items.ENDER_CHEST);
        this.cart((ItemLike)ModRegisterables.pistonCart.item(), (ItemLike)Items.PISTON);
        this.cart((ItemLike)ModRegisterables.stonecutterCart.item(), (ItemLike)Items.STONECUTTER);
        this.cart((ItemLike)ModRegisterables.anvilCart.item(), (ItemLike)Items.ANVIL);
    }

    private void createShearsRecipes() {
        this.shaped(new Object[]{ModItems.diamondShears, " I", "I ", Character.valueOf('I'), Tags.Items.GEMS_DIAMOND});
    }

    private void createBoatRecipes() {
        Ingredient shulker = Ingredient.of((ItemLike[])new ItemLike[]{Items.SHULKER_BOX, Items.BLACK_SHULKER_BOX, Items.BLUE_SHULKER_BOX, Items.BROWN_SHULKER_BOX, Items.CYAN_SHULKER_BOX, Items.GRAY_SHULKER_BOX, Items.GREEN_SHULKER_BOX, Items.LIGHT_BLUE_SHULKER_BOX, Items.LIGHT_GRAY_SHULKER_BOX, Items.LIME_SHULKER_BOX, Items.MAGENTA_SHULKER_BOX, Items.ORANGE_SHULKER_BOX, Items.PINK_SHULKER_BOX, Items.PURPLE_SHULKER_BOX, Items.RED_SHULKER_BOX, Items.WHITE_SHULKER_BOX, Items.YELLOW_SHULKER_BOX});
        this.shapeless(new Object[]{ModItems.oakShulkerBoat, shulker, Items.OAK_BOAT});
        this.shapeless(new Object[]{ModItems.spruceShulkerBoat, shulker, Items.SPRUCE_BOAT});
        this.shapeless(new Object[]{ModItems.birchShulkerBoat, shulker, Items.BIRCH_BOAT});
        this.shapeless(new Object[]{ModItems.jungleShulkerBoat, shulker, Items.JUNGLE_BOAT});
        this.shapeless(new Object[]{ModItems.acaciaShulkerBoat, shulker, Items.ACACIA_BOAT});
        this.shapeless(new Object[]{ModItems.cherryShulkerBoat, shulker, Items.CHERRY_BOAT});
        this.shapeless(new Object[]{ModItems.darkOakShulkerBoat, shulker, Items.DARK_OAK_BOAT});
        this.shapeless(new Object[]{ModItems.mangroveShulkerBoat, shulker, Items.MANGROVE_BOAT});
        this.shapeless(new Object[]{ModItems.bambooShulkerRaft, shulker, Items.BAMBOO_RAFT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.oakShulkerBoat, "with_shell"), ModItems.oakShulkerBoat, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.OAK_CHEST_BOAT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.spruceShulkerBoat, "with_shell"), ModItems.spruceShulkerBoat, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.SPRUCE_CHEST_BOAT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.birchShulkerBoat, "with_shell"), ModItems.birchShulkerBoat, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.BIRCH_CHEST_BOAT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.jungleShulkerBoat, "with_shell"), ModItems.jungleShulkerBoat, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.JUNGLE_CHEST_BOAT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.acaciaShulkerBoat, "with_shell"), ModItems.acaciaShulkerBoat, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.ACACIA_CHEST_BOAT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.cherryShulkerBoat, "with_shell"), ModItems.cherryShulkerBoat, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.CHERRY_CHEST_BOAT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.darkOakShulkerBoat, "with_shell"), ModItems.darkOakShulkerBoat, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.DARK_OAK_CHEST_BOAT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.mangroveShulkerBoat, "with_shell"), ModItems.mangroveShulkerBoat, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.MANGROVE_CHEST_BOAT});
        this.shaped(new Object[]{this.loc((ItemLike)ModItems.bambooShulkerRaft, "with_shell"), ModItems.bambooShulkerRaft, "s", "b", "s", Character.valueOf('s'), Items.SHULKER_SHELL, Character.valueOf('b'), Items.BAMBOO_CHEST_RAFT});
    }

    private void cart(ItemLike cart, ItemLike content) {
        this.shaped(new Object[]{cart, "i", "c", Character.valueOf('i'), content, Character.valueOf('c'), Items.MINECART});
    }

    private void wall(ItemLike wall, Ingredient ingredient) {
        this.shaped(new Object[]{wall, "XXX", "XXX", Character.valueOf('X'), ingredient});
        this.stoneCutting(ingredient, wall);
    }

    private void removeNbt(ItemLike item) {
        this.shapeless(new Object[]{this.loc(item, "remove_nbt"), item, item});
    }
}

