/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.config.FeatureConfig;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public abstract class RailBlock
extends BaseRailBlock
implements Registerable {
    protected final ModX mod;
    private final Item item;
    private final boolean hasCorners;
    private final boolean hasSlopes;

    public RailBlock(ModX mod, boolean corners, BlockBehaviour.Properties properties) {
        this(mod, corners, properties, new Item.Properties());
    }

    public RailBlock(ModX mod, boolean corners, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(!corners, properties);
        this.mod = mod;
        this.item = new BlockItem((Block)this, itemProperties){

            public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
                return RailBlock.this.isEnabled(enabledFeatures);
            }
        };
        this.hasCorners = this.getShapeProperty().getPossibleValues().containsAll((Collection<?>)ImmutableList.of((Object)RailShape.NORTH_EAST, (Object)RailShape.NORTH_WEST, (Object)RailShape.SOUTH_EAST, (Object)RailShape.SOUTH_WEST));
        this.hasSlopes = this.getShapeProperty().getPossibleValues().containsAll((Collection<?>)ImmutableList.of((Object)RailShape.ASCENDING_NORTH, (Object)RailShape.ASCENDING_SOUTH, (Object)RailShape.ASCENDING_EAST, (Object)RailShape.ASCENDING_WEST));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        builder.register(Registries.ITEM, (Object)this.item);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getShapeProperty()});
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Nonnull
    public abstract Property<RailShape> getShapeProperty();

    @Nonnull
    public BlockState rotate(@Nonnull BlockState state, @Nonnull Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> {
                switch ((RailShape)state.getValue(this.getShapeProperty())) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ASCENDING_EAST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_SOUTH: 
                    case EAST_WEST: 
                }
                yield state;
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                switch ((RailShape)state.getValue(this.getShapeProperty())) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORTH_SOUTH: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: 
                }
                yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_WEST);
            }
            case Rotation.CLOCKWISE_90 -> {
                switch ((RailShape)state.getValue(this.getShapeProperty())) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORTH_SOUTH: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                yield (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_EAST);
            }
            default -> state;
        };
    }

    @Nonnull
    public BlockState mirror(BlockState state, Mirror mirror) {
        RailShape railshape = (RailShape)state.getValue(this.getShapeProperty());
        block0 : switch (mirror) {
            case LEFT_RIGHT: {
                return switch (railshape) {
                    case RailShape.ASCENDING_NORTH -> (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_SOUTH);
                    case RailShape.ASCENDING_SOUTH -> (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_NORTH);
                    case RailShape.SOUTH_EAST -> (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_EAST);
                    case RailShape.SOUTH_WEST -> (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_WEST);
                    case RailShape.NORTH_WEST -> (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_WEST);
                    case RailShape.NORTH_EAST -> (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_EAST);
                    default -> super.mirror(state, mirror);
                };
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_WEST);
                        break block0;
                    }
                    case ASCENDING_WEST: {
                        state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_EAST);
                        break block0;
                    }
                    case SOUTH_EAST: {
                        state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_WEST);
                        break block0;
                    }
                    case SOUTH_WEST: {
                        state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_EAST);
                        break block0;
                    }
                    case NORTH_WEST: {
                        state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_EAST);
                        break block0;
                    }
                    case NORTH_EAST: {
                        state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_WEST);
                    }
                }
            }
        }
        return super.mirror(state, mirror);
    }

    public boolean isStraight() {
        return !this.hasCorners;
    }

    public boolean canMakeSlopes(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return this.hasSlopes;
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Transportation.moreRails;
    }
}

