/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import com.mojang.serialization.MapCodec;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.block.ModProperties;
import de.melanx.utilitix.content.track.MinecartTinkererItem;
import de.melanx.utilitix.content.track.TrackUtil;
import de.melanx.utilitix.content.track.rails.ControllerRailBlock;
import de.melanx.utilitix.content.track.rails.FilterRailBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.mod.ModX;

public class FilterRailBlock
extends ControllerRailBlock<FilterRailBlockEntity> {
    public static final MapCodec<FilterRailBlock> CODEC = Block.simpleCodec(FilterRailBlock::new);

    public FilterRailBlock(BlockBehaviour.Properties properties) {
        this((ModX)UtilitiX.getInstance(), false, properties);
    }

    public FilterRailBlock(ModX mod, boolean reinforced, BlockBehaviour.Properties properties) {
        super(mod, FilterRailBlockEntity::new, reinforced, properties);
    }

    public FilterRailBlock(ModX mod, boolean reinforced, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, FilterRailBlockEntity::new, reinforced, properties, itemProperties);
    }

    @Override
    @Nonnull
    public Property<RailShape> getShapeProperty() {
        return ModProperties.RAIL_SHAPE_FLAT_STRAIGHT;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ModProperties.REVERSE});
        builder.add(new Property[]{ModProperties.RAIL_SIDE});
    }

    @Nonnull
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        Direction direction = context.getHorizontalDirection();
        Pair<RailShape, Boolean> properties = TrackUtil.getForPlacement(direction);
        state = (BlockState)((BlockState)state.setValue(this.getShapeProperty(), (Comparable)((RailShape)properties.getLeft()))).setValue((Property)ModProperties.REVERSE, (Comparable)((Boolean)properties.getRight()));
        Vec3 hitVec = context.getClickLocation();
        double xd = hitVec.x - (double)context.getClickedPos().getX();
        double zd = hitVec.z - (double)context.getClickedPos().getZ();
        boolean side = !(direction.getStepX() < 0 && zd < 0.5 || direction.getStepX() > 0 && zd > 0.5 || direction.getStepZ() < 0 && xd > 0.5 || direction.getStepZ() > 0 && xd < 0.5);
        return (BlockState)state.setValue((Property)ModProperties.RAIL_SIDE, (Comparable)Boolean.valueOf(!side));
    }

    @Nonnull
    public RailShape getRailDirection(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable AbstractMinecart cart) {
        ItemStack filterCart;
        RailShape baseShape = (RailShape)state.getValue(this.getShapeProperty());
        ItemStack itemStack = filterCart = cart == null ? ItemStack.EMPTY : MinecartTinkererItem.getLabelStack(cart);
        if (filterCart.isEmpty()) {
            return baseShape;
        }
        ItemStack filterThis = ((FilterRailBlockEntity)((Object)this.getBlockEntity(level, pos))).getFilterStack();
        if (filterThis.isEmpty()) {
            return baseShape;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)filterThis, (ItemStack)filterCart)) {
            return baseShape;
        }
        boolean reverse = (Boolean)state.getValue((Property)ModProperties.REVERSE);
        boolean side = (Boolean)state.getValue((Property)ModProperties.RAIL_SIDE);
        if (baseShape == RailShape.NORTH_SOUTH) {
            if (reverse && side) {
                return RailShape.NORTH_WEST;
            }
            if (reverse) {
                return RailShape.NORTH_EAST;
            }
            if (side) {
                return RailShape.SOUTH_WEST;
            }
            return RailShape.SOUTH_EAST;
        }
        if (reverse && side) {
            return RailShape.NORTH_WEST;
        }
        if (reverse) {
            return RailShape.SOUTH_WEST;
        }
        if (side) {
            return RailShape.NORTH_EAST;
        }
        return RailShape.SOUTH_EAST;
    }

    @Nonnull
    protected MapCodec<? extends BaseRailBlock> codec() {
        return CODEC;
    }
}

