/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import com.mojang.serialization.MapCodec;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.block.ModProperties;
import de.melanx.utilitix.content.track.TrackUtil;
import de.melanx.utilitix.content.track.carts.BaseCart;
import de.melanx.utilitix.content.track.rails.PoweredRailBlock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.mod.ModX;

public class DirectionalRailBlock
extends PoweredRailBlock {
    public static final MapCodec<DirectionalRailBlock> CODEC = Block.simpleCodec(DirectionalRailBlock::new);

    public DirectionalRailBlock(BlockBehaviour.Properties properties) {
        this((ModX)UtilitiX.getInstance(), 0.4, properties);
    }

    public DirectionalRailBlock(ModX mod, double maxRailSpeed, BlockBehaviour.Properties properties) {
        super(mod, maxRailSpeed, properties);
    }

    public DirectionalRailBlock(ModX mod, double maxRailSpeed, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, maxRailSpeed, properties, itemProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ModProperties.REVERSE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ModProperties.REVERSE});
    }

    @Nonnull
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        Direction direction = context.getHorizontalDirection();
        Pair<RailShape, Boolean> properties = TrackUtil.getForPlacement(direction);
        return (BlockState)((BlockState)state.setValue(this.getShapeProperty(), (Comparable)((RailShape)properties.getLeft()))).setValue((Property)ModProperties.REVERSE, (Comparable)((Boolean)properties.getRight()));
    }

    @Override
    public void onMinecartPass(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull AbstractMinecart cart) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            TrackUtil.slowDownCart(level, cart, this.maxRailSpeed);
            return;
        }
        Direction dir = TrackUtil.getFace((RailShape)state.getValue(this.getShapeProperty()), (Boolean)state.getValue((Property)ModProperties.REVERSE));
        Vec3 motion = cart.getDeltaMovement();
        boolean movingWrongly = false;
        if (dir.getAxis() == Direction.Axis.X) {
            movingWrongly = motion.x != 0.0 && motion.x > 0.0 != dir.getStepX() > 0;
        } else if (dir.getAxis() == Direction.Axis.Z) {
            boolean bl = motion.z != 0.0 && motion.z > 0.0 != dir.getStepZ() > 0 ? true : (movingWrongly = false);
        }
        if (movingWrongly) {
            cart.setDeltaMovement((double)dir.getStepX() * (this.maxRailSpeed / 5.0), 0.0, (double)dir.getStepZ() * (this.maxRailSpeed / 10.0));
        } else {
            if (BaseCart.getHorizontalDistanceSqr(motion) < this.maxRailSpeed / 10.0 * (this.maxRailSpeed / 10.0)) {
                cart.setDeltaMovement((double)dir.getStepX() * (this.maxRailSpeed / 5.0), 0.0, (double)dir.getStepZ() * (this.maxRailSpeed / 5.0));
            }
            TrackUtil.accelerateStraight(level, pos, (RailShape)state.getValue(this.getShapeProperty()), cart, BaseCart.getHorizontalDistanceSqr(motion) < this.maxRailSpeed / 5.0 ? 1.5 * this.maxRailSpeed : this.maxRailSpeed);
        }
    }
}

