/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.content.track.carts.BaseCart;
import de.melanx.utilitix.content.track.carts.piston.PistonCartMenu;
import de.melanx.utilitix.content.track.carts.piston.PistonCartMode;
import de.melanx.utilitix.content.track.rails.PistonControllerRailBlock;
import de.melanx.utilitix.registration.ModItemTags;
import de.melanx.utilitix.registration.ModSerializers;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.inventory.BaseItemStackHandler;

public class PistonCart
extends BaseCart {
    private static final EntityDataAccessor<PistonCartMode> MODE = SynchedEntityData.defineId(PistonCart.class, ModSerializers.pistonCartMode);
    private PistonCartMode mode = PistonCartMode.IDLE;
    private final BaseItemStackHandler railIn = BaseItemStackHandler.builder((int)12).validator(stack -> stack.is(ItemTags.RAILS), IntStream.range(0, 12).toArray()).build();
    private final BaseItemStackHandler torchIn;
    private final BaseItemStackHandler railOut = BaseItemStackHandler.builder((int)12).validator(stack -> stack.is(ItemTags.RAILS), IntStream.range(0, 12).toArray()).build();

    public PistonCart(EntityType<?> type, Level level) {
        super(type, level);
        this.torchIn = BaseItemStackHandler.builder((int)1).validator(stack -> stack.is(ModItemTags.RAIL_POWER_SOURCES), new int[]{0}).build();
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MODE, (Object)PistonCartMode.IDLE);
    }

    public void onSyncedDataUpdated(@Nonnull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (MODE.equals(key)) {
            this.mode = (PistonCartMode)((Object)this.entityData.get(MODE));
        }
    }

    @Nonnull
    public BlockState getDefaultDisplayBlockState() {
        if (this.mode == PistonCartMode.PLACE) {
            return (BlockState)Blocks.PISTON.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP);
        }
        if (this.mode == PistonCartMode.REPLACE) {
            return (BlockState)Blocks.STICKY_PISTON.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP);
        }
        return (BlockState)((BlockState)Blocks.PISTON.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.EXTENDED, (Comparable)Boolean.valueOf(true));
    }

    public void destroy(@Nonnull DamageSource source) {
        int i;
        super.destroy(source);
        for (i = 0; i < this.railIn.getSlots(); ++i) {
            this.spawnAtLocation(this.railIn.getStackInSlot(i));
        }
        for (i = 0; i < this.torchIn.getSlots(); ++i) {
            this.spawnAtLocation(this.torchIn.getStackInSlot(i));
        }
        for (i = 0; i < this.railOut.getSlots(); ++i) {
            this.spawnAtLocation(this.railOut.getStackInSlot(i));
        }
    }

    @Nonnull
    public InteractionResult interact(@Nonnull Player player, @Nonnull InteractionHand hand) {
        InteractionResult ret = super.interact(player, hand);
        if (ret.consumesAction()) {
            return ret;
        }
        if (!this.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PistonCartMenu.TYPE.open(serverPlayer, this.getDisplayName(), (Object)this.getId());
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.mode == PistonCartMode.PLACE && this.shouldDoRailFunctions()) {
            BlockPos pos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()));
            if (!this.level().getBlockState(pos).is(BlockTags.RAILS) && !this.level().getBlockState(pos.below()).is(BlockTags.RAILS)) {
                Pair<ItemStack, Integer> result = this.findRail((IItemHandlerModifiable)this.railIn);
                ItemStack railStack = (ItemStack)result.getLeft();
                int railSlot = (Integer)result.getRight();
                if (railStack.isEmpty() || railSlot < 0) {
                    return;
                }
                List<ItemStack> placeResult = this.placeRail(railStack, pos, false);
                if (placeResult != null) {
                    this.railIn.extractItem(railSlot, 1, false);
                    for (ItemStack drop : placeResult) {
                        this.depositOrDrop(drop.copy());
                    }
                }
            }
            return;
        }
        if (this.mode == PistonCartMode.REPLACE && this.shouldDoRailFunctions()) {
            BlockPos pos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()));
            if (!this.level().getBlockState(pos).is(BlockTags.RAILS) && this.level().getBlockState(pos.below()).is(BlockTags.RAILS)) {
                pos = pos.below();
            }
            if (!this.level().getBlockState(pos).is(BlockTags.RAILS)) {
                return;
            }
            Pair<ItemStack, Integer> result = this.findRail((IItemHandlerModifiable)this.railIn);
            ItemStack railStack = (ItemStack)result.getLeft();
            int railSlot = (Integer)result.getRight();
            if (railStack.isEmpty() || railSlot < 0) {
                return;
            }
            List<ItemStack> placeResult = this.placeRail(railStack, pos, true);
            if (placeResult != null) {
                this.railIn.extractItem(railSlot, 1, false);
                for (ItemStack drop : placeResult) {
                    this.depositOrDrop(drop.copy());
                }
            }
        }
    }

    private Pair<ItemStack, Integer> findRail(IItemHandlerModifiable inventory) {
        for (int slot = inventory.getSlots() - 1; slot >= 0; --slot) {
            ItemStack extracted = inventory.extractItem(slot, 1, true);
            if (extracted.isEmpty()) continue;
            return Pair.of((Object)extracted.copy(), (Object)slot);
        }
        return Pair.of((Object)ItemStack.EMPTY, (Object)-1);
    }

    private void depositOrDrop(ItemStack rail) {
        ItemStack remainder = rail;
        for (int slot = 0; slot < this.railOut.getSlots(); ++slot) {
            if (!(remainder = this.railOut.insertItem(slot, remainder, false)).isEmpty()) continue;
            return;
        }
        if (!remainder.isEmpty()) {
            ItemEntity ie = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), remainder);
            this.level().addFreshEntity((Entity)ie);
        }
    }

    @Nullable
    private List<ItemStack> placeRail(ItemStack railStack, BlockPos pos, boolean replace) {
        BlockState oldState = this.level().getBlockState(pos);
        if (replace) {
            RailShape shape;
            switch (this.getMotionDirection()) {
                case WEST: 
                case EAST: {
                    RailShape railShape = RailShape.EAST_WEST;
                    break;
                }
                default: {
                    RailShape railShape = shape = RailShape.NORTH_SOUTH;
                }
            }
            if (oldState.getBlock() instanceof BaseRailBlock) {
                shape = ((BaseRailBlock)oldState.getBlock()).getRailDirection(oldState, (BlockGetter)this.level(), pos, (AbstractMinecart)this);
            }
            List drops = null;
            if (this.level() instanceof ServerLevel) {
                drops = Block.getDrops((BlockState)oldState, (ServerLevel)((ServerLevel)this.level()), (BlockPos)pos, (BlockEntity)this.level().getBlockEntity(pos));
            }
            if (this.doPlaceRail(railStack, shape, pos, oldState.getBlock())) {
                return drops == null ? ImmutableList.of() : drops;
            }
            return null;
        }
        if (oldState.isAir() || oldState.canBeReplaced()) {
            RailShape shape = switch (this.getMotionDirection()) {
                case Direction.WEST, Direction.EAST -> RailShape.EAST_WEST;
                default -> RailShape.NORTH_SOUTH;
            };
            return this.doPlaceRail(railStack, shape, pos, null) ? ImmutableList.of() : null;
        }
        return null;
    }

    private boolean doPlaceRail(ItemStack railStack, RailShape shape, BlockPos pos, @Nullable Block oldBlock) {
        Item item = railStack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block railBlock = blockItem.getBlock();
        if (railBlock instanceof PistonControllerRailBlock) {
            return false;
        }
        if (oldBlock != null && railBlock == oldBlock) {
            this.tryPower(pos);
            return false;
        }
        if (!(railBlock instanceof BaseRailBlock)) {
            return false;
        }
        BaseRailBlock baseRailBlock = (BaseRailBlock)railBlock;
        if (!baseRailBlock.getShapeProperty().getPossibleValues().contains(shape)) {
            return false;
        }
        BlockState railState = railBlock.getStateForPlacement((BlockPlaceContext)new DirectionalPlaceContext(this.level(), pos, this.getMotionDirection(), railStack.copy(), Direction.UP));
        if (!(railState = (BlockState)railState.setValue(baseRailBlock.getShapeProperty(), (Comparable)shape)).canSurvive((LevelReader)this.level(), pos)) {
            return false;
        }
        this.level().setBlock(pos, railState, 11);
        this.tryPower(pos);
        return true;
    }

    private void tryPower(BlockPos railPos) {
        Item item;
        BlockState railState = this.level().getBlockState(railPos);
        if (!railState.hasProperty((Property)BlockStateProperties.POWERED) || ((Boolean)railState.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            return;
        }
        if (!this.level().getBlockState(railPos.below()).canOcclude()) {
            return;
        }
        BlockPos pos = railPos.below(2);
        Pair<ItemStack, Integer> result = this.findRail((IItemHandlerModifiable)this.torchIn);
        ItemStack torchStack = (ItemStack)result.getLeft();
        int torchSlot = (Integer)result.getRight();
        if (torchStack.isEmpty() || torchSlot < 0 || !((item = torchStack.getItem()) instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState oldState = this.level().getBlockState(pos);
        BlockState state = blockItem.getBlock().defaultBlockState();
        if (!state.canSurvive((LevelReader)this.level(), pos)) {
            return;
        }
        List drops = null;
        if (this.level() instanceof ServerLevel) {
            drops = Block.getDrops((BlockState)oldState, (ServerLevel)((ServerLevel)this.level()), (BlockPos)pos, (BlockEntity)this.level().getBlockEntity(pos));
        }
        this.level().setBlock(pos, state, 11);
        this.torchIn.extractItem(torchSlot, 1, false);
        if (drops == null) {
            return;
        }
        for (ItemStack drop : drops) {
            ItemEntity ie = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), drop.copy());
            this.level().addFreshEntity((Entity)ie);
        }
    }

    public IItemHandlerModifiable getRailInputInventory() {
        return this.railIn;
    }

    public IItemHandlerModifiable getRailOutputInventory() {
        return this.railOut;
    }

    public IItemHandlerModifiable getTorchInventory() {
        return this.torchIn;
    }

    public PistonCartMode getMode() {
        return this.mode;
    }

    public void setMode(PistonCartMode mode) {
        this.mode = mode;
        this.entityData.set(MODE, (Object)mode);
    }

    protected void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        RegistryAccess registryAccess = this.registryAccess();
        this.railIn.deserializeNBT((HolderLookup.Provider)registryAccess, compound.getCompound("RailInput"));
        this.torchIn.deserializeNBT((HolderLookup.Provider)registryAccess, compound.getCompound("TorchIn"));
        this.railOut.deserializeNBT((HolderLookup.Provider)registryAccess, compound.getCompound("RailOut"));
        String modeName = compound.getString("Mode");
        try {
            this.mode = PistonCartMode.valueOf(modeName);
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            this.mode = PistonCartMode.IDLE;
        }
        if (this.mode != this.entityData.get(MODE)) {
            this.entityData.set(MODE, (Object)this.mode);
        }
    }

    protected void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        RegistryAccess registryAccess = this.registryAccess();
        compound.put("RailInput", (Tag)this.railIn.serializeNBT((HolderLookup.Provider)registryAccess));
        compound.put("TorchIn", (Tag)this.torchIn.serializeNBT((HolderLookup.Provider)registryAccess));
        compound.put("RailOut", (Tag)this.railOut.serializeNBT((HolderLookup.Provider)registryAccess));
        compound.putString("Mode", this.mode.name());
    }
}

