/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track;

import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.track.tinkerer.MinecartTinkererMenu;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;

public class MinecartTinkererItem
extends ItemBase {
    public MinecartTinkererItem(ModX mod, Item.Properties properties) {
        super(mod, properties);
    }

    public boolean onLeftClickEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull Entity entity) {
        if (!(entity instanceof AbstractMinecart)) {
            return false;
        }
        AbstractMinecart minecart = (AbstractMinecart)entity;
        Level level = player.level();
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecartTinkererMenu.open(serverPlayer, minecart);
        }
        return true;
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull Player player) {
        return true;
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Transportation.moreRails || FeatureConfig.Transportation.moreMinecarts;
    }

    public static ItemStack getLabelStack(AbstractMinecart entity) {
        CompoundTag tag = entity.getPersistentData();
        return ItemStack.parseOptional((HolderLookup.Provider)entity.registryAccess(), (CompoundTag)tag.getCompound("utilitix_minecart_label_item"));
    }

    public static void setLabelStack(AbstractMinecart entity, ItemStack stack) {
        CompoundTag tag = entity.getPersistentData();
        tag.put("utilitix_minecart_label_item", stack.saveOptional((HolderLookup.Provider)entity.registryAccess()));
    }
}

