/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.brewery;

import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.brewery.AdvancedBreweryBlockEntity;
import de.melanx.utilitix.content.brewery.AdvancedBreweryMenu;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AdvancedBreweryScreen
extends AbstractContainerScreen<AdvancedBreweryMenu> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"textures/container/advanced_brewery.png");
    private static final int[] BUBBLE_SIZES = new int[]{29, 24, 20, 16, 11, 6, 0};

    public AdvancedBreweryScreen(AdvancedBreweryMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        AdvancedBreweryBlockEntity blockEntity = (AdvancedBreweryBlockEntity)((AdvancedBreweryMenu)this.menu).getBlockEntity();
        int fuelWidth = Mth.clamp((int)Math.round((float)(18 * blockEntity.getFuel() + 19) / 20.0f), (int)0, (int)18);
        if (blockEntity.getFuel() > 0 && fuelWidth > 0) {
            guiGraphics.blit(TEXTURE, this.leftPos + 60, this.topPos + 44, 176, 29, fuelWidth, 4);
        }
        int brewTime = Mth.clamp((int)blockEntity.getBrewTime(), (int)0, (int)400);
        if (blockEntity.getFuel() <= 0 || brewTime <= 0) {
            return;
        }
        int textureHeight = Mth.clamp((int)Math.round(28.0f * ((float)brewTime / 400.0f)), (int)0, (int)28);
        if (textureHeight > 0) {
            guiGraphics.blit(TEXTURE, this.leftPos + 97, this.topPos + 16, 176, 0, 9, textureHeight);
        }
        if ((textureHeight = BUBBLE_SIZES[(400 - brewTime) / 2 % BUBBLE_SIZES.length]) > 0) {
            guiGraphics.blit(TEXTURE, this.leftPos + 63, this.topPos + 14 + 29 - textureHeight, 185, 29 - textureHeight, 12, textureHeight);
        }
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String s = this.title.getString();
        guiGraphics.drawString(this.font, s, this.imageWidth / 2 - this.font.width(s) / 2, 5, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, Color.DARK_GRAY.getRGB(), false);
    }
}

