/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.network.handler;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.glue.StickyChunk;
import de.melanx.utilitix.registration.ModAttachmentTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class StickyChunkUpdate
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(UtilitiX.getInstance().resource("sticky_chunk_update"));

    public StickyChunkUpdate() {
        super(TYPE, PacketFlow.CLIENTBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Level level = ctx.player().level();
        if (!level.isClientSide) {
            this.sendWarning(msg);
            return;
        }
        if (!level.hasChunkAt(new BlockPos(msg.pos().getMinBlockX(), 0, msg.pos().getMinBlockZ()))) {
            this.sendWarning(msg);
            return;
        }
        LevelChunk loaded = level.getChunk(msg.pos().x, msg.pos().z);
        if (loaded == null) {
            this.sendWarning(msg);
            return;
        }
        StickyChunk glue = (StickyChunk)loaded.getData(ModAttachmentTypes.stickyChunk);
        glue.attach(loaded);
        glue.loadFrom(msg.data());
    }

    private void sendWarning(Message msg) {
        UtilitiX.getInstance().logger.warn("Received invalid sticky chunk packet for unloaded chunk: ({},{})", (Object)msg.pos().x, (Object)msg.pos().z);
    }

    public record Message(ChunkPos pos, StickyChunk data) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeInt(msg.pos().x);
            buffer.writeInt(msg.pos().z);
            msg.data().write((FriendlyByteBuf)buffer);
        }, buffer -> {
            ChunkPos pos = new ChunkPos(buffer.readInt(), buffer.readInt());
            StickyChunk chunk = new StickyChunk();
            chunk.read((FriendlyByteBuf)buffer);
            return new Message(pos, chunk);
        });

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

