/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.data;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.block.ModProperties;
import de.melanx.utilitix.content.redstone.ComparatorRedirectorBlock;
import de.melanx.utilitix.content.redstone.DimmableRedstoneLampBlock;
import de.melanx.utilitix.data.state.RailState;
import de.melanx.utilitix.registration.ModBlocks;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.model.BlockStateProviderBase;

public class BlockStateProvider
extends BlockStateProviderBase {
    public static final ResourceLocation LINKED_REPEATER_PARENT = ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"block/linked_repeater_base");
    public static final ResourceLocation TEXTURE_REPEATER_OFF = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/repeater");
    public static final ResourceLocation TEXTURE_REPEATER_ON = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/repeater_on");
    public static final ResourceLocation TEXTURE_TORCH_OFF = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/redstone_torch_off");
    public static final ResourceLocation TEXTURE_TORCH_ON = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/redstone_torch");

    public BlockStateProvider(DatagenContext context) {
        super(context);
    }

    protected void setup() {
        this.manualState((Block)ModBlocks.weakRedstoneTorch);
        this.manualState((Block)ModBlocks.weakRedstoneTorch.wallTorch);
        this.manualModel((Block)ModBlocks.experienceCrystal);
        this.manualModel((Block)ModBlocks.advancedBrewery);
    }

    protected void defaultState(ResourceLocation id, Block block, Supplier<ModelFile> model) {
        if (block == ModBlocks.linkedRepeater) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            ModelBuilder modelOn = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(id.getPath() + "_on", LINKED_REPEATER_PARENT)).texture("repeater", TEXTURE_REPEATER_ON)).texture("torch", TEXTURE_TORCH_ON);
            ModelBuilder modelOff = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(id.getPath() + "_off", LINKED_REPEATER_PARENT)).texture("repeater", TEXTURE_REPEATER_OFF)).texture("torch", TEXTURE_TORCH_OFF);
            for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
                Iterator iterator = BlockStateProperties.POWER.getPossibleValues().iterator();
                while (iterator.hasNext()) {
                    int power = (Integer)iterator.next();
                    builder.partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir).with((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(power)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)(power > 0 ? modelOn : modelOff), 0, (int)dir.toYRot(), false)});
                }
            }
            return;
        }
        if (block instanceof BaseRailBlock) {
            BooleanProperty reverseProperty;
            Property shapeProperty = block.getStateDefinition().getProperties().stream().filter(p -> RailShape.class.equals((Object)p.getValueClass())).findFirst().orElse(null);
            Object object = reverseProperty = block.getStateDefinition().getProperties().contains(ModProperties.REVERSE) ? ModProperties.REVERSE : null;
            if (shapeProperty == null) {
                throw new IllegalStateException("Rail block without shape property.");
            }
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            if (block.getStateDefinition().getProperties().contains(ModProperties.RAIL_SIDE)) {
                RailState stateLeft = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty, p -> p.with((Property)ModProperties.RAIL_SIDE, (Comparable)Boolean.valueOf(false)));
                RailState stateRight = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty, p -> p.with((Property)ModProperties.RAIL_SIDE, (Comparable)Boolean.valueOf(true)));
                stateLeft.generate(this, builder, id, "left");
                stateRight.generate(this, builder, id, "right");
            } else if (block.getStateDefinition().getProperties().contains(BlockStateProperties.POWERED)) {
                RailState stateOff = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty, p -> p.with((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
                RailState stateOn = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty, p -> p.with((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
                stateOff.generate(this, builder, id);
                stateOn.generate(this, builder, id, "on");
            } else {
                RailState state = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty);
                state.generate(this, builder, id);
            }
            return;
        }
        if (block == ModBlocks.crudeFurnace) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            ModelBuilder modelOn = this.models().orientable(id.getPath() + "_on", this.modLoc("block/" + id.getPath() + "_side"), this.modLoc("block/" + id.getPath() + "_front_on"), this.modLoc("block/" + id.getPath() + "_top"));
            ModelBuilder modelOff = this.models().orientable(id.getPath(), this.modLoc("block/" + id.getPath() + "_side"), this.modLoc("block/" + id.getPath() + "_front"), this.modLoc("block/" + id.getPath() + "_top"));
            for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
                Iterator iterator = AbstractFurnaceBlock.LIT.getPossibleValues().iterator();
                while (iterator.hasNext()) {
                    boolean value = (Boolean)iterator.next();
                    builder.partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(value)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)(value ? modelOn : modelOff), 0, (int)dir.getOpposite().toYRot(), false)});
                }
            }
            return;
        }
        if (block == ModBlocks.stoneWall) {
            this.wallBlock((WallBlock)block, this.mcLoc("block/stone"));
            return;
        }
        if (block == ModBlocks.dimmableRedstoneLamp) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            Iterator iterator = DimmableRedstoneLampBlock.SIGNAL.getPossibleValues().iterator();
            while (iterator.hasNext()) {
                ConfiguredModel signalModel;
                boolean isDefault;
                int signal = (Integer)iterator.next();
                boolean bl = isDefault = signal == 0 || signal == 15;
                if (isDefault) {
                    boolean on = signal == 15;
                    signalModel = new ConfiguredModel((ModelFile)this.models().cubeAll(id.getPath() + (String)(on ? "_" + signal : ""), this.mcLoc("block/redstone_lamp" + (on ? "_on" : ""))));
                } else {
                    signalModel = new ConfiguredModel((ModelFile)this.models().cubeAll(id.getPath() + "_" + signal, this.modLoc("block/dimmable_redstone_lamp_" + signal)));
                }
                builder.partialState().with((Property)DimmableRedstoneLampBlock.SIGNAL, (Comparable)Integer.valueOf(signal)).addModels(new ConfiguredModel[]{signalModel});
            }
            return;
        }
        super.defaultState(id, block, model);
    }

    protected ModelFile defaultModel(ResourceLocation id, Block block) {
        if (block == ModBlocks.linkedRepeater || block instanceof BaseRailBlock || block == ModBlocks.crudeFurnace) {
            return null;
        }
        if (block instanceof ComparatorRedirectorBlock) {
            ResourceLocation top = ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"block/comparator_redirector_top");
            ResourceLocation bottom = ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"block/comparator_redirector_bottom");
            if (((ComparatorRedirectorBlock)block).direction == Direction.DOWN) {
                ResourceLocation tmp = top;
                top = bottom;
                bottom = tmp;
            }
            return this.models().cubeBottomTop(id.getPath(), ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"block/comparator_redirector_side"), top, bottom);
        }
        return super.defaultModel(id, block);
    }
}

