/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.tinkerer;

import de.melanx.utilitix.content.track.MinecartTinkererItem;
import de.melanx.utilitix.content.track.rails.ControllerRailBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.moddingx.libx.menu.MenuBase;
import org.moddingx.libx.menu.type.AdvancedMenuType;

public class MinecartTinkererMenu
extends MenuBase {
    private static final int LABEL_SLOT = 0;
    private static final Component TITLE = Component.translatable((String)"screen.utilitix.minecart_tinkerer");
    public static final AdvancedMenuType<MinecartTinkererMenu, Target> TYPE = AdvancedMenuType.create(MinecartTinkererMenu::new, (StreamCodec)StreamCodec.of((buf, target) -> {
        buf.writeEnum((Enum)target.type());
        switch (target.type().ordinal()) {
            case 0: {
                buf.writeVarInt(target.entityId());
                break;
            }
            case 1: {
                buf.writeBlockPos(target.pos());
            }
        }
    }, buf -> {
        TargetType targetType = (TargetType)buf.readEnum(TargetType.class);
        return switch (targetType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Target.entity(buf.readVarInt());
            case 1 -> Target.block(buf.readBlockPos());
        };
    }));
    private final Level level;
    private final Target target;
    @Nullable
    private final AbstractMinecart minecart;
    @Nullable
    private final ControllerRailBlockEntity controllerRail;

    public MinecartTinkererMenu(@Nullable MenuType<?> type, int windowId, Level level, Target target, Player player, Inventory playerInventory) {
        super(type, windowId, playerInventory);
        this.level = level;
        this.target = target;
        switch (target.type().ordinal()) {
            case 0: {
                AbstractMinecart cart;
                Entity entity = level.getEntity(target.entityId());
                this.minecart = entity instanceof AbstractMinecart ? (cart = (AbstractMinecart)entity) : null;
                this.controllerRail = null;
                break;
            }
            case 1: {
                ControllerRailBlockEntity rail;
                this.minecart = null;
                BlockEntity blockEntity = level.getBlockEntity(target.pos());
                this.controllerRail = blockEntity instanceof ControllerRailBlockEntity ? (rail = (ControllerRailBlockEntity)blockEntity) : null;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown target type: " + String.valueOf((Object)target.type()));
            }
        }
        ItemStackHandler labelInventory = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                if (slot != 0) {
                    return;
                }
                if (!MinecartTinkererMenu.this.level.isClientSide) {
                    ItemStack stack = this.getStackInSlot(0);
                    if (MinecartTinkererMenu.this.minecart != null) {
                        MinecartTinkererItem.setLabelStack(MinecartTinkererMenu.this.minecart, stack);
                    } else if (MinecartTinkererMenu.this.controllerRail != null) {
                        MinecartTinkererMenu.this.controllerRail.setFilterStack(stack);
                    }
                }
            }
        };
        switch (target.type().ordinal()) {
            case 0: {
                labelInventory.setStackInSlot(0, MinecartTinkererItem.getLabelStack(this.minecart));
                break;
            }
            case 1: {
                labelInventory.setStackInSlot(0, this.controllerRail.getFilterStack().copy());
            }
        }
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)labelInventory, 0, 80, 18));
        this.layoutPlayerInventorySlots(8, 50);
    }

    public static void open(ServerPlayer player, AbstractMinecart minecart) {
        TYPE.open(player, TITLE, (Object)Target.entity(minecart.getId()));
    }

    public static void open(ServerPlayer player, BlockPos pos) {
        TYPE.open(player, TITLE, (Object)Target.block(pos));
    }

    @Nullable
    public AbstractMinecart getMinecart() {
        return this.minecart;
    }

    @Nullable
    public ControllerRailBlockEntity getControllerRail() {
        return this.controllerRail;
    }

    public boolean stillValid(@Nonnull Player player) {
        return switch (this.target.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (player.distanceToSqr((Entity)this.minecart) <= 64.0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> !this.controllerRail.isRemoved();
        };
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = slot.getItem();
        ItemStack copy = slotStack.copy();
        if (index == 0 ? !this.moveItemStackTo(slotStack, 1, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, 1, false)) {
            return ItemStack.EMPTY;
        }
        if (slotStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return copy;
    }

    public record Target(TargetType type, int entityId, BlockPos pos) {
        public static Target entity(int entityId) {
            return new Target(TargetType.ENTITY, entityId, BlockPos.ZERO);
        }

        public static Target block(BlockPos pos) {
            return new Target(TargetType.BLOCK, -1, pos);
        }
    }

    public static enum TargetType {
        ENTITY,
        BLOCK;

    }
}

