/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import de.melanx.utilitix.content.track.rails.RailBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.moddingx.libx.mod.ModX;

public abstract class PowerableRailBlock
extends RailBlock {
    @Nullable
    private final TagKey<Block> powerables;

    public PowerableRailBlock(ModX mod, @Nullable TagKey<Block> powerables, BlockBehaviour.Properties properties) {
        this(mod, powerables, properties, new Item.Properties());
    }

    public PowerableRailBlock(ModX mod, @Nullable TagKey<Block> powerables, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, false, properties, itemProperties);
        this.powerables = powerables;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    protected boolean findPower(Level level, BlockPos pos, BlockState state, boolean searchForward, int recursionCount) {
        Block block;
        if (recursionCount >= 8 || !((block = state.getBlock()) instanceof PowerableRailBlock)) {
            return false;
        }
        PowerableRailBlock powerableRailBlock = (PowerableRailBlock)block;
        BlockPos searchPos = pos.immutable();
        boolean lookDown = true;
        RailShape rail = (RailShape)state.getValue(powerableRailBlock.getShapeProperty());
        switch (rail) {
            case NORTH_SOUTH: {
                searchPos = searchPos.relative(searchForward ? Direction.SOUTH : Direction.NORTH);
                break;
            }
            case EAST_WEST: {
                searchPos = searchPos.relative(searchForward ? Direction.EAST : Direction.WEST);
                break;
            }
            case ASCENDING_EAST: {
                if (searchForward) {
                    searchPos = searchPos.west();
                } else {
                    searchPos = searchPos.east().above();
                    lookDown = false;
                }
                rail = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (searchForward) {
                    searchPos = searchPos.west().above();
                    lookDown = false;
                } else {
                    searchPos = searchPos.east();
                }
                rail = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (searchForward) {
                    searchPos = searchPos.south();
                } else {
                    searchPos = searchPos.north().above();
                    lookDown = false;
                }
                rail = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (searchForward) {
                    searchPos = searchPos.south().above();
                    lookDown = false;
                } else {
                    searchPos = searchPos.north();
                }
                rail = RailShape.NORTH_SOUTH;
            }
        }
        return this.canPower(level, searchPos, searchForward, recursionCount, rail) || lookDown && this.canMakeSlopes(level.getBlockState(searchPos), (BlockGetter)level, searchPos) && this.canPower(level, searchPos.below(), searchForward, recursionCount, rail);
    }

    private boolean canPower(Level level, BlockPos pos, boolean searchForward, int recursionCount, RailShape shape) {
        RailShape rail;
        BlockState target = level.getBlockState(pos);
        if (!(target.getBlock() instanceof PowerableRailBlock)) {
            return false;
        }
        RailShape railShape = rail = target.getBlock() == this ? this.getRailDirection(target, (BlockGetter)level, pos, null) : RailShape.NORTH_SOUTH;
        if (shape == RailShape.EAST_WEST && (rail == RailShape.NORTH_SOUTH || rail == RailShape.ASCENDING_NORTH || rail == RailShape.ASCENDING_SOUTH)) {
            return false;
        }
        if (shape == RailShape.NORTH_SOUTH && (rail == RailShape.EAST_WEST || rail == RailShape.ASCENDING_EAST || rail == RailShape.ASCENDING_WEST)) {
            return false;
        }
        if (this.powerables == null ? target.getBlock() == this : target.is(this.powerables)) {
            return level.hasNeighborSignal(pos) || this.findPower(level, pos, target, searchForward, recursionCount + 1);
        }
        return false;
    }

    protected void updateState(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block) {
        boolean shouldBePowered;
        if (state.getBlock() != this) {
            return;
        }
        boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        boolean bl = shouldBePowered = level.hasNeighborSignal(pos) || this.findPower(level, pos, state, true, 0) || this.findPower(level, pos, state, false, 0);
        if (powered == shouldBePowered) {
            return;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
        level.updateNeighborsAt(pos.below(), (Block)this);
        if (((RailShape)state.getValue(this.getShapeProperty())).isAscending()) {
            level.updateNeighborsAt(pos.above(), (Block)this);
        }
    }
}

