/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts.piston;

import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.track.carts.PistonCart;
import de.melanx.utilitix.content.track.carts.piston.PistonCartMenu;
import de.melanx.utilitix.network.handler.PistonCartModeCycle;
import de.melanx.utilitix.registration.ModItemTags;
import de.melanx.utilitix.util.GhostItemRenderHelper;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class PistonCartScreen
extends AbstractContainerScreen<PistonCartMenu> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"textures/container/piston_cart.png");
    private static final int TORCHES_SLOT = 12;
    private static final int INPUT_SIZE = 12;
    private static final int SLOT_OFFSET = 18;
    private final List<ItemStack> railItems;
    private final List<ItemStack> torchItems;

    public PistonCartScreen(PistonCartMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 186;
        Registry itemRegistry = ((PistonCartMenu)this.menu).getLevel().registryAccess().registryOrThrow(Registries.ITEM);
        this.railItems = itemRegistry.getOrCreateTag(ItemTags.RAILS).stream().map(ItemStack::new).toList();
        this.torchItems = itemRegistry.getOrCreateTag(ModItemTags.RAIL_POWER_SOURCES).stream().map(ItemStack::new).toList();
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> PacketDistributor.sendToServer((CustomPacketPayload)new PistonCartModeCycle.Message(((PistonCart)((PistonCartMenu)this.menu).entity).getId()), (CustomPacketPayload[])new CustomPacketPayload[0])).pos(this.leftPos + 64, this.topPos + 17).size(48, 18).build());
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (!((PistonCartMenu)this.menu).getSlot(12).hasItem()) {
            GhostItemRenderHelper.renderGhostItem(this.torchItems, guiGraphics, this.leftPos + 80, this.topPos + 72);
        }
        for (int i = 0; i < 12; ++i) {
            ItemStack stack = ((PistonCartMenu)this.menu).getSlot(i).getItem();
            if (!stack.isEmpty()) continue;
            GhostItemRenderHelper.renderGhostItem(this.railItems, guiGraphics, this.leftPos + 8 + i % 3 * 18, this.topPos + 18 + i / 3 * 18);
        }
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String s = this.title.getString();
        guiGraphics.drawString(this.font, s, (float)(this.imageWidth / 2 - this.font.width(s) / 2), 5.0f, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, Color.DARK_GRAY.getRGB(), false);
        if (((PistonCartMenu)this.menu).entity != null) {
            int modeStrWidth = this.font.width((FormattedText)((PistonCart)((PistonCartMenu)this.menu).entity).getMode().name);
            guiGraphics.drawString(this.font, ((PistonCart)((PistonCartMenu)this.menu).entity).getMode().name.getString(), (float)(88 - modeStrWidth / 2), 22.0f, 0xFFFFFF, true);
        }
    }
}

