/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts;

import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.track.carts.BaseCart;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.SetupContext;

public class BaseCartItem
extends ItemBase
implements Registerable {
    public final EntityType<? extends BaseCart> minecartType;
    public final DispenseItemBehavior dispenseBehaviour = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispense = new DefaultDispenseItemBehavior();

        @Nonnull
        public ItemStack execute(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
            double yOffset;
            RailShape rail;
            Direction dir = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel world = source.level();
            double x = (double)source.pos().getX() + (double)dir.getStepX() * 1.125;
            double y = (double)source.pos().getY() + (double)dir.getStepY();
            double z = (double)source.pos().getZ() + (double)dir.getStepZ() * 1.125;
            BlockPos target = source.pos().relative(dir);
            BlockState targetState = world.getBlockState(target);
            RailShape railShape = rail = targetState.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)targetState.getBlock()).getRailDirection(targetState, (BlockGetter)world, target, null) : RailShape.NORTH_SOUTH;
            if (targetState.is(BlockTags.RAILS)) {
                yOffset = rail.isAscending() ? 0.6 : 0.1;
            } else {
                if (!targetState.isAir() || !world.getBlockState(target.below()).is(BlockTags.RAILS)) {
                    return this.defaultDispense.dispense(source, stack);
                }
                BlockState railState = world.getBlockState(target.below());
                RailShape railDown = railState.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)railState.getBlock()).getRailDirection(railState, (BlockGetter)world, target.below(), null) : RailShape.NORTH_SOUTH;
                yOffset = dir != Direction.DOWN && railDown.isAscending() ? -0.4 : -0.9;
            }
            BaseCart cart = (BaseCart)BaseCartItem.this.minecartType.create((Level)world);
            if (cart == null) {
                return this.defaultDispense.dispense(source, stack);
            }
            cart.setPos(x, y + yOffset, z);
            cart.setDeltaMovement(Vec3.ZERO);
            cart.xo = x;
            cart.yo = y + yOffset;
            cart.zo = z;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                cart.setCustomName(stack.getHoverName());
            }
            world.addFreshEntity((Entity)cart);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };

    public BaseCartItem(ModX mod, EntityType<? extends BaseCart> minecartType, Item.Properties properties) {
        super(mod, properties);
        this.minecartType = minecartType;
    }

    public void setupCommon(SetupContext ctx) {
        ctx.enqueue(() -> DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)this.dispenseBehaviour));
    }

    @Nonnull
    protected String getOrCreateDescriptionId() {
        return this.minecartType.getDescriptionId();
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (!state.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (!level.isClientSide) {
            BaseCart cart = (BaseCart)this.minecartType.create(level);
            if (cart == null) {
                return InteractionResult.FAIL;
            }
            RailShape rail = state.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)state.getBlock()).getRailDirection(state, (BlockGetter)level, pos, null) : RailShape.NORTH_SOUTH;
            cart.setPos((double)pos.getX() + 0.5, (double)pos.getY() + (rail.isAscending() ? 0.5625 : 0.0625), (double)pos.getZ() + 0.5);
            cart.setDeltaMovement(Vec3.ZERO);
            cart.xo = (double)pos.getX() + 0.5;
            cart.yo = (double)pos.getY() + (rail.isAscending() ? 0.5625 : 0.0625);
            cart.zo = (double)pos.getZ() + 0.5;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                cart.setCustomName(stack.getHoverName());
            }
            level.addFreshEntity((Entity)cart);
        }
        stack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Transportation.moreMinecarts;
    }
}

