/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts;

import de.melanx.utilitix.content.track.carts.BaseCart;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AnvilCart
extends BaseCart {
    public AnvilCart(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Nonnull
    public BlockState getDefaultDisplayBlockState() {
        return Blocks.ANVIL.defaultBlockState();
    }

    public void tick() {
        AABB collisionBox;
        AABB aABB = collisionBox = this.getCollisionHandler() != null ? this.getCollisionHandler().getMinecartCollisionBox((AbstractMinecart)this) : this.getBoundingBox().inflate(0.2, 0.0, 0.2);
        if (!this.canBeRidden() || BaseCart.getHorizontalDistanceSqr(this.getDeltaMovement()) <= 0.010000000000000002) {
            for (Entity entity : this.level().getEntities((Entity)this, collisionBox)) {
                if (this.hasPassenger(entity) || !entity.isPushable() || entity instanceof AbstractMinecart) continue;
                this.boostEntity(entity);
            }
            super.tick();
            return;
        }
        for (Entity entity : this.level().getEntities((Entity)this, collisionBox, EntitySelector.pushableBy((Entity)this))) {
            if (entity instanceof AbstractMinecart) continue;
            if (entity instanceof Player || entity instanceof IronGolem || this.isVehicle() || entity.isPassenger()) {
                this.boostEntity(entity);
                continue;
            }
            if (entity.startRiding((Entity)this)) continue;
            this.boostEntity(entity);
        }
        super.tick();
    }

    public boolean canCollideWith(@Nonnull Entity entity) {
        return super.canCollideWith(entity) && entity instanceof AbstractMinecart;
    }

    private void boostEntity(Entity entity) {
        double boost = Mth.clamp((double)Math.sqrt(AnvilCart.getHorizontalDistanceSqr(this.getDeltaMovement())), (double)0.05, (double)0.5);
        Direction minecartDir = this.getMotionDirection();
        Vec3 targetVec = new Vec3((entity.getX() - this.getX()) * (minecartDir.getAxis() == Direction.Axis.Z ? 2.5 : 0.8), 0.0, (entity.getZ() - this.getZ()) * (minecartDir.getAxis() == Direction.Axis.X ? 2.5 : 0.8)).normalize().scale(1.5 * boost);
        entity.hurt(this.damageSources().anvil(entity), 0.25f);
        entity.push(targetVec.x, targetVec.y, targetVec.z);
    }
}

