/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.quiver;

import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.quiver.QuiverContainer;
import de.melanx.utilitix.content.quiver.QuiverMenu;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;

public class QuiverItem
extends ItemBase
implements Registerable {
    public static final int SLOT_SIZE = 9;

    public QuiverItem(ModX mod, Item.Properties properties) {
        super(mod, properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            QuiverMenu.open(serverPlayer, hand);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    @Nullable
    public static QuiverContainer getInventory(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return new QuiverContainer(stack);
    }

    public static boolean isEmpty(ItemStack stack) {
        QuiverContainer inv = QuiverItem.getInventory(stack);
        return inv == null || inv.isEmpty();
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(@Nonnull ItemStack stack, @Nonnull Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.INFINITY);
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Items.quiver;
    }
}

