/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.crudefurnace;

import de.melanx.utilitix.content.crudefurnace.CrudeFurnaceBlockEntity;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.moddingx.libx.menu.BlockEntityMenu;
import org.moddingx.libx.menu.type.AdvancedMenuType;

public class CrudeFurnaceMenu
extends BlockEntityMenu<CrudeFurnaceBlockEntity> {
    public static final AdvancedMenuType<CrudeFurnaceMenu, BlockPos> TYPE = AdvancedMenuType.create(CrudeFurnaceMenu::new, (StreamCodec)StreamCodec.of((buf, pos) -> buf.writeBlockPos(pos), buffer -> RegistryFriendlyByteBuf.readBlockPos((ByteBuf)buffer)));

    public CrudeFurnaceMenu(@Nullable MenuType<? extends BlockEntityMenu<?>> type, int windowId, Level level, BlockPos pos, Player player, Inventory inventory) {
        super(type, windowId, level, pos, player, inventory, 2, 3);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)((CrudeFurnaceBlockEntity)this.blockEntity).getInventory(), 0, 56, 53));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)((CrudeFurnaceBlockEntity)this.blockEntity).getInventory(), 1, 56, 17));
        this.addSlot((Slot)new OutputSlot(player, (CrudeFurnaceBlockEntity)this.blockEntity, 2, 116, 35));
        this.layoutPlayerInventorySlots(8, 84);
    }

    private static class OutputSlot
    extends SlotItemHandler {
        private final Player player;
        private final CrudeFurnaceBlockEntity blockEntity;
        private int removeCount;

        public OutputSlot(Player player, CrudeFurnaceBlockEntity blockEntity, int index, int xPosition, int yPosition) {
            super(blockEntity.output, index, xPosition, yPosition);
            this.player = player;
            this.blockEntity = blockEntity;
        }

        public void onTake(@Nonnull Player player, @Nonnull ItemStack stack) {
            this.checkTakeAchievements(stack);
            super.onTake(player, stack);
        }

        @Nonnull
        public ItemStack remove(int amount) {
            if (this.hasItem()) {
                this.removeCount += Math.min(amount, this.getItem().getCount());
            }
            return super.remove(amount);
        }

        protected void onQuickCraft(@Nonnull ItemStack stack, int amount) {
            this.removeCount += amount;
            this.checkTakeAchievements(stack);
        }

        protected void checkTakeAchievements(ItemStack stack) {
            stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.blockEntity.unlockRecipes(serverPlayer);
            }
            this.removeCount = 0;
            EventHooks.firePlayerSmeltedEvent((Player)this.player, (ItemStack)stack);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return false;
        }

        public void set(@Nonnull ItemStack stack) {
        }

        public void initialize(@Nonnull ItemStack stack) {
        }
    }
}

