/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.brewery;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.config.FeatureConfig;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;

public class FailedPotionItem
extends ItemBase {
    public static final int DRINK_DURATION = 32;
    private static final List<Holder<MobEffect>> VERY_LONG_POTIONS = ImmutableList.of((Object)MobEffects.BAD_OMEN, (Object)MobEffects.UNLUCK);
    private static final List<Holder<MobEffect>> LONG_POTIONS = ImmutableList.of((Object)MobEffects.MOVEMENT_SLOWDOWN, (Object)MobEffects.POISON, (Object)MobEffects.HUNGER, (Object)MobEffects.WEAKNESS);
    private static final List<Holder<MobEffect>> SHORT_POTIONS = ImmutableList.of((Object)MobEffects.CONFUSION, (Object)MobEffects.BLINDNESS, (Object)MobEffects.LEVITATION);

    public FailedPotionItem(ModX mod, Item.Properties properties) {
        super(mod, properties);
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entityLiving) {
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        if (!level.isClientSide) {
            entityLiving.addEffect(new MobEffectInstance(VERY_LONG_POTIONS.get(level.random.nextInt(VERY_LONG_POTIONS.size())), 2400));
            entityLiving.addEffect(new MobEffectInstance(LONG_POTIONS.get(level.random.nextInt(LONG_POTIONS.size())), 600));
            entityLiving.addEffect(new MobEffectInstance(SHORT_POTIONS.get(level.random.nextInt(SHORT_POTIONS.size())), 200));
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        if (player == null || !player.getAbilities().instabuild) {
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
            if (player != null) {
                player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        }
        return stack;
    }

    public int getUseDuration(@Nonnull ItemStack stack, @Nonnull LivingEntity entity) {
        return 32;
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public boolean isFoil(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Machines.advancedBrewery;
    }
}

