/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jei;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.compat.jei.UtiliJei;
import de.melanx.utilitix.recipe.BreweryRecipe;
import de.melanx.utilitix.registration.ModBlocks;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class BreweryCategory
implements IRecipeCategory<BreweryRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final Component localizedName;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated bubbles;
    private final IDrawableStatic blazeHeat;

    public BreweryCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)UtilitiX.getInstance().modid, (String)"textures/container/advanced_brewery.png");
        this.background = guiHelper.drawableBuilder(location, 55, 15, 64, 60).addPadding(1, 0, 0, 50).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModBlocks.advancedBrewery));
        this.localizedName = Component.translatable((String)"screen.utilitix.advanced_brewery");
        this.arrow = guiHelper.drawableBuilder(location, 176, 0, 9, 28).buildAnimated(400, IDrawableAnimated.StartDirection.TOP, false);
        BubbleTimer bubblesTickTimer = new BubbleTimer(guiHelper);
        this.bubbles = guiHelper.drawableBuilder(location, 185, 0, 12, 29).buildAnimated((ITickTimer)bubblesTickTimer, IDrawableAnimated.StartDirection.BOTTOM);
        this.blazeHeat = guiHelper.createDrawable(location, 176, 29, 18, 4);
        this.slot = guiHelper.getSlotDrawable();
    }

    @Nonnull
    public RecipeType<BreweryRecipe> getRecipeType() {
        return UtiliJei.BREWING_RECIPE;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    public int getWidth() {
        return 114;
    }

    public int getHeight() {
        return 61;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull BreweryRecipe recipe, @Nonnull IFocusGroup focuses) {
        ItemStack stack = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.AWKWARD);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 24, 44).addItemStack(stack);
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 3).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 3).addItemStack(RecipeUtil.getResultItem((Recipe)recipe))).setBackground(this.slot, -1, -1);
    }

    public void draw(@Nonnull BreweryRecipe recipe, @Nonnull IRecipeSlotsView slotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        this.blazeHeat.draw(guiGraphics, 5, 30);
        this.bubbles.draw(guiGraphics, 8, 0);
        this.arrow.draw(guiGraphics, 42, 2);
    }

    private static class BubbleTimer
    implements ITickTimer {
        private static final int[] BUBBLE_SIZES = new int[]{29, 24, 20, 16, 11, 6, 0};
        private final ITickTimer timer;

        public BubbleTimer(IGuiHelper guiHelper) {
            this.timer = guiHelper.createTickTimer(14, BUBBLE_SIZES.length - 1, false);
        }

        public int getValue() {
            return BUBBLE_SIZES[this.timer.getValue()];
        }

        public int getMaxValue() {
            return BUBBLE_SIZES[0];
        }
    }
}

