/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jade;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.compat.jade.UtilJade;
import de.melanx.utilitix.content.brewery.AdvancedBreweryBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ElementHelper;

public class AdvancedBreweryProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final ResourceLocation UID = UtilitiX.getInstance().resource("advanced_brewery");
    public static final AdvancedBreweryProvider INSTANCE = new AdvancedBreweryProvider();
    private static final ItemStack BLAZE_POWDER = new ItemStack((ItemLike)Items.BLAZE_POWDER);
    private static final ItemStack CLOCK = new ItemStack((ItemLike)Items.CLOCK);

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(UtilJade.ADVANCED_BREWERY)) {
            return;
        }
        CompoundTag tag = accessor.getServerData().getCompound("AdvancedBrewery");
        int fuel = tag.getInt("fuel");
        int time = tag.getInt("time");
        IElementHelper helper = IElementHelper.get();
        tooltip.add(helper.smallItem(BLAZE_POWDER));
        tooltip.append((IElement)helper.text((Component)Component.translatable((String)Integer.toString(fuel))));
        if (time > 0 && time != 400) {
            tooltip.append(helper.spacer(5, 0));
            tooltip.append(helper.smallItem(CLOCK).message(" "));
            tooltip.append(helper.text((Component)IThemeHelper.get().seconds(time, accessor.tickRate())).translate(ElementHelper.SMALL_ITEM_OFFSET));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        AdvancedBreweryBlockEntity brewery = (AdvancedBreweryBlockEntity)blockAccessor.getBlockEntity();
        CompoundTag tag = new CompoundTag();
        tag.putInt("time", 400 - brewery.getBrewTime());
        tag.putInt("fuel", brewery.getFuel());
        data.put("AdvancedBrewery", (Tag)tag);
    }
}

