/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.mixin;

import de.melanx.utilitix.config.FeatureConfig;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public abstract class MixinWanderingTraderSpawner {
    @Shadow
    @Final
    private ServerLevelData serverLevelData;

    @Shadow
    @Nullable
    protected abstract BlockPos findSpawnPositionNear(LevelReader var1, BlockPos var2, int var3);

    @Shadow
    protected abstract boolean hasEnoughSpace(BlockGetter var1, BlockPos var2);

    @Shadow
    protected abstract void tryToSpawnLlamaFor(ServerLevel var1, WanderingTrader var2, int var3);

    @Inject(method={"spawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void utilitix$spawn(ServerLevel level, CallbackInfoReturnable<Boolean> cir) {
        if (!FeatureConfig.Misc.InWorldChanges.wanderingTrader) {
            return;
        }
        List players = level.getPlayers(player -> true);
        boolean returnValue = false;
        for (ServerPlayer player2 : players) {
            WanderingTrader trader;
            if (player2 == null || level.random.nextInt(10) <= 1) continue;
            int i = 48;
            BlockPos playerPos = player2.blockPosition();
            Optional optional = level.getPoiManager().find(poiTypeHolder -> poiTypeHolder.is(PoiTypes.MEETING), pos -> true, playerPos, i, PoiManager.Occupancy.ANY);
            BlockPos checkPos = optional.orElse(playerPos);
            BlockPos possibleSpawnPos = this.findSpawnPositionNear((LevelReader)level, checkPos, i);
            if (possibleSpawnPos == null || !this.hasEnoughSpace((BlockGetter)level, possibleSpawnPos) || level.getBiome(possibleSpawnPos).is(BiomeTags.WITHOUT_WANDERING_TRADER_SPAWNS) || (trader = (WanderingTrader)EntityType.WANDERING_TRADER.spawn(level, null, null, possibleSpawnPos, MobSpawnType.EVENT, false, false)) == null) continue;
            for (int j = 0; j < 2; ++j) {
                this.tryToSpawnLlamaFor(level, trader, 4);
            }
            this.serverLevelData.setWanderingTraderId(trader.getUUID());
            trader.setDespawnDelay(48000);
            trader.setWanderTarget(checkPos);
            trader.restrictTo(checkPos, 16);
            returnValue = true;
        }
        cir.setReturnValue((Object)returnValue);
    }
}

