/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import com.mojang.serialization.MapCodec;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.track.TrackUtil;
import de.melanx.utilitix.content.track.rails.PowerableRailBlock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.moddingx.libx.mod.ModX;

public class PoweredRailBlock
extends PowerableRailBlock {
    public final double maxRailSpeed;
    public static final MapCodec<PoweredRailBlock> CODEC = Block.simpleCodec(PoweredRailBlock::new);

    public PoweredRailBlock(BlockBehaviour.Properties properties) {
        this((ModX)UtilitiX.getInstance(), 0.7, properties);
    }

    public PoweredRailBlock(ModX mod, double maxRailSpeed, BlockBehaviour.Properties properties) {
        this(mod, maxRailSpeed, properties, new Item.Properties());
    }

    public PoweredRailBlock(ModX mod, double maxRailSpeed, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, null, properties, itemProperties);
        this.maxRailSpeed = maxRailSpeed;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void onMinecartPass(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull AbstractMinecart cart) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            TrackUtil.accelerateStraight(level, pos, this.getRailDirection(state, (BlockGetter)level, pos, cart), cart, this.maxRailSpeed);
        } else {
            TrackUtil.slowDownCart(level, cart, this.maxRailSpeed);
        }
    }

    public float getRailMaxSpeed(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull AbstractMinecart cart) {
        return (float)this.maxRailSpeed;
    }

    @Nonnull
    protected MapCodec<? extends BaseRailBlock> codec() {
        return CODEC;
    }

    @Override
    @Nonnull
    public Property<RailShape> getShapeProperty() {
        return BlockStateProperties.RAIL_SHAPE_STRAIGHT;
    }
}

