/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts;

import de.melanx.utilitix.config.CommonConfig;
import de.melanx.utilitix.content.track.carts.BaseCart;
import de.melanx.utilitix.content.track.carts.stonecutter.StonecutterCartMode;
import de.melanx.utilitix.registration.ModSerializers;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class StonecutterCart
extends BaseCart {
    public static final int MAX_PROGRESS = 50;
    private static final EntityDataAccessor<StonecutterCartMode> MODE = SynchedEntityData.defineId(StonecutterCart.class, ModSerializers.stonecutterCartMode);
    private static final EntityDataAccessor<Boolean> IN_REVERSE = SynchedEntityData.defineId(StonecutterCart.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private StonecutterCartMode mode = StonecutterCartMode.TOP;
    @Nullable
    private BlockPos breakingBlock = null;
    @Nullable
    private BlockPos lastSuccess = null;
    private int breakProgress = 0;
    @Nullable
    private Vec3 storedMotion = null;
    private boolean cartHasMoved = false;

    public StonecutterCart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MODE, (Object)StonecutterCartMode.TOP);
        builder.define(IN_REVERSE, (Object)false);
    }

    public void onSyncedDataUpdated(@Nonnull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (MODE.equals(key)) {
            this.mode = (StonecutterCartMode)((Object)this.entityData.get(MODE));
        } else if (IN_REVERSE.equals(key)) {
            this.flipped = (Boolean)this.entityData.get(IN_REVERSE);
        }
    }

    @Nonnull
    public BlockState getDefaultDisplayBlockState() {
        return Blocks.STONECUTTER.defaultBlockState();
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        if (this.breakingBlock != null) {
            this.level().destroyBlockProgress(this.getId(), this.breakingBlock, -1);
        }
    }

    public void tick() {
        int oz;
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        BlockPos pos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()));
        if (!this.level().getBlockState(pos).is(BlockTags.RAILS) && this.level().getBlockState(pos.below()).is(BlockTags.RAILS)) {
            pos = pos.below();
        }
        Direction minecartDir = this.getMotionDirection();
        Direction leftDir = minecartDir.getCounterClockWise();
        int ox = minecartDir.getStepX() * this.getMode().offsetTrack + leftDir.getStepX() * this.getMode().offsetLeft;
        if (!(pos = pos.offset(ox, this.getMode().offsetHor, oz = minecartDir.getStepZ() * this.getMode().offsetTrack + leftDir.getStepZ() * this.getMode().offsetLeft)).equals((Object)this.breakingBlock)) {
            if (this.breakingBlock != null) {
                this.level().destroyBlockProgress(this.getId(), this.breakingBlock, -1);
            }
            this.breakingBlock = pos;
            this.breakProgress = 0;
        }
        boolean shouldResetMotion = true;
        if (!this.breakingBlock.equals((Object)this.lastSuccess) && this.cartHasMoved) {
            BlockState state = this.level().getBlockState(this.breakingBlock);
            if (state.isAir() || state.canBeReplaced() || state.is(BlockTags.RAILS)) {
                this.breakProgress = 0;
                this.finalTick(shouldResetMotion);
                return;
            }
            float hardness = state.getDestroySpeed((BlockGetter)this.level(), this.breakingBlock);
            if (hardness < 0.0f || hardness > CommonConfig.Track.stonecutterMaxHardness) {
                this.breakProgress = 0;
                this.finalTick(shouldResetMotion);
                return;
            }
            this.breakProgress += (int)Mth.clamp((float)(5.0f - hardness), (float)1.0f, (float)5.0f);
            if (this.breakProgress >= 50 || hardness == 0.0f) {
                List drops = null;
                if (this.level() instanceof ServerLevel) {
                    drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)this.level()), (BlockPos)this.breakingBlock, (BlockEntity)this.level().getBlockEntity(pos));
                }
                this.level().setBlock(this.breakingBlock, Blocks.AIR.defaultBlockState(), 11);
                if (drops != null) {
                    for (ItemStack drop : drops) {
                        ItemEntity ie = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), drop.copy());
                        ie.setDeltaMovement(Vec3.ZERO);
                        this.level().addFreshEntity((Entity)ie);
                    }
                }
                this.level().destroyBlockProgress(this.getId(), this.breakingBlock, -1);
                this.lastSuccess = this.breakingBlock;
                this.breakingBlock = null;
                this.breakProgress = 0;
            } else {
                int stage = Mth.clamp((int)Math.round((float)this.breakProgress / 50.0f * 10.0f), (int)0, (int)9);
                this.level().destroyBlockProgress(this.getId(), this.breakingBlock, stage);
                if (this.storedMotion == null) {
                    this.storedMotion = this.getDeltaMovement();
                }
                this.setDeltaMovement(Vec3.ZERO);
                shouldResetMotion = false;
            }
        }
        this.finalTick(shouldResetMotion);
    }

    private void finalTick(boolean shouldResetMotion) {
        if (shouldResetMotion && this.storedMotion != null) {
            this.setDeltaMovement(this.storedMotion);
            this.storedMotion = null;
        }
        if (BaseCart.getHorizontalDistanceSqr(this.getDeltaMovement()) >= 0.010000000000000002) {
            this.cartHasMoved = true;
        }
        if (this.flipped != (Boolean)this.entityData.get(IN_REVERSE)) {
            this.entityData.set(IN_REVERSE, (Object)this.flipped);
        }
    }

    public StonecutterCartMode getMode() {
        return this.mode;
    }

    public void setMode(StonecutterCartMode mode) {
        this.mode = mode;
        this.entityData.set(MODE, (Object)mode);
    }

    @Nonnull
    public InteractionResult interact(@Nonnull Player player, @Nonnull InteractionHand hand) {
        InteractionResult ret = super.interact(player, hand);
        if (ret.consumesAction()) {
            return ret;
        }
        if (!this.level().isClientSide) {
            int modeIdx = this.getMode().ordinal();
            StonecutterCartMode[] modes = StonecutterCartMode.values();
            this.setMode(modes[(modeIdx + 1) % modes.length]);
        }
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
    }

    protected void readAdditionalSaveData(@Nonnull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        String modeName = nbt.getString("Mode");
        try {
            this.mode = StonecutterCartMode.valueOf(modeName);
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            this.mode = StonecutterCartMode.TOP;
        }
        if (this.mode != this.entityData.get(MODE)) {
            this.entityData.set(MODE, (Object)this.mode);
        }
        this.breakingBlock = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"BreakPos").orElse(null);
        this.lastSuccess = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"LastSuccessfulBreak").orElse(null);
        this.breakProgress = nbt.getInt("BreakProgress");
        if (nbt.contains("StoredMotion", 10)) {
            CompoundTag motionNbt = nbt.getCompound("StoredMotion");
            this.storedMotion = new Vec3(motionNbt.getDouble("X"), motionNbt.getDouble("Y"), motionNbt.getDouble("Z"));
        } else {
            this.storedMotion = null;
        }
        this.cartHasMoved = nbt.getBoolean("CartHasMoved");
    }

    protected void addAdditionalSaveData(@Nonnull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Mode", this.mode.name());
        if (this.breakingBlock == null) {
            nbt.remove("BreakPos");
        } else {
            nbt.put("BreakPos", NbtUtils.writeBlockPos((BlockPos)this.breakingBlock));
        }
        if (this.lastSuccess == null) {
            nbt.remove("LastSuccessfulBreak");
        } else {
            nbt.put("LastSuccessfulBreak", NbtUtils.writeBlockPos((BlockPos)this.lastSuccess));
        }
        nbt.putInt("BreakProgress", this.breakProgress);
        if (this.storedMotion == null) {
            nbt.remove("StoredMotion");
        } else {
            CompoundTag motionNBT = new CompoundTag();
            motionNBT.putDouble("X", this.storedMotion.x);
            motionNBT.putDouble("Y", this.storedMotion.y);
            motionNBT.putDouble("Z", this.storedMotion.z);
            nbt.put("StoredMotion", (Tag)motionNBT);
        }
        nbt.putBoolean("CartHasMoved", this.cartHasMoved);
    }
}

