/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track;

import de.melanx.utilitix.content.track.carts.BaseCart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class TrackUtil {
    public static void accelerateStraight(Level level, BlockPos pos, RailShape shape, AbstractMinecart cart, double accelerationValue) {
        Vec3 motion = cart.getDeltaMovement();
        double horizontalMotion = Math.sqrt(BaseCart.getHorizontalDistanceSqr(motion));
        if (horizontalMotion > accelerationValue / 40.0) {
            cart.setDeltaMovement(motion.add(motion.x / horizontalMotion * (accelerationValue * 0.15), 0.0, motion.z / horizontalMotion * (accelerationValue * 0.15)));
            return;
        }
        double motionX = motion.x;
        double motionZ = motion.z;
        if (shape == RailShape.EAST_WEST) {
            if (level.getBlockState(pos.west()).isRedstoneConductor((BlockGetter)level, pos.west())) {
                motionX = accelerationValue / 20.0;
            } else if (level.getBlockState(pos.east()).isRedstoneConductor((BlockGetter)level, pos.east())) {
                motionX = -(accelerationValue / 20.0);
            }
        } else if (shape == RailShape.NORTH_SOUTH) {
            if (level.getBlockState(pos.north()).isRedstoneConductor((BlockGetter)level, pos.north())) {
                motionZ = accelerationValue / 20.0;
            } else if (level.getBlockState(pos.south()).isRedstoneConductor((BlockGetter)level, pos.south())) {
                motionZ = -(accelerationValue / 20.0);
            }
        }
        cart.setDeltaMovement(motionX, motion.y, motionZ);
    }

    public static void slowDownCart(Level level, AbstractMinecart cart, double accelerationValue) {
        double horizontalMotion = Math.sqrt(BaseCart.getHorizontalDistanceSqr(cart.getDeltaMovement()));
        if (horizontalMotion < accelerationValue * 0.75) {
            cart.setDeltaMovement(Vec3.ZERO);
        } else {
            cart.setDeltaMovement(cart.getDeltaMovement().multiply(1.0 / (5.0 * accelerationValue), 0.0, 1.0 / (5.0 * accelerationValue)));
        }
    }

    public static Direction getFace(RailShape shape, boolean reverse) {
        return switch (shape) {
            case RailShape.NORTH_SOUTH, RailShape.ASCENDING_NORTH, RailShape.ASCENDING_SOUTH -> {
                if (reverse) {
                    yield Direction.SOUTH;
                }
                yield Direction.NORTH;
            }
            case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST, RailShape.EAST_WEST -> {
                if (reverse) {
                    yield Direction.WEST;
                }
                yield Direction.EAST;
            }
            default -> Direction.NORTH;
        };
    }

    public static Pair<RailShape, Boolean> getForPlacement(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> Pair.of((Object)RailShape.NORTH_SOUTH, (Object)false);
            case Direction.SOUTH -> Pair.of((Object)RailShape.NORTH_SOUTH, (Object)true);
            case Direction.EAST -> Pair.of((Object)RailShape.EAST_WEST, (Object)false);
            case Direction.WEST -> Pair.of((Object)RailShape.EAST_WEST, (Object)true);
            default -> Pair.of((Object)RailShape.NORTH_SOUTH, (Object)false);
        };
    }

    public static void defaultCollisions(AbstractMinecart cart, Entity other) {
        double zd;
        if (cart.level().isClientSide || cart.noPhysics || other.noPhysics || cart.hasPassenger(other)) {
            return;
        }
        double xd = other.getX() - cart.getX();
        double horizontalSquared = xd * xd + (zd = other.getZ() - cart.getZ()) * zd;
        if (horizontalSquared < 0.001) {
            return;
        }
        double horizontal = Mth.sqrt((float)((float)horizontalSquared));
        xd /= horizontal;
        zd /= horizontal;
        if (!(other instanceof AbstractMinecart)) {
            cart.push(-xd, 0.0, -zd);
            other.push(xd / 4.0, 0.0, zd / 4.0);
            return;
        }
        AbstractMinecart otherCart = (AbstractMinecart)other;
        Vec3 diffVecN = new Vec3(otherCart.getX() - cart.getX(), 0.0, otherCart.getZ() - cart.getZ()).normalize();
        Vec3 cartRot = new Vec3(Math.cos(Math.toRadians(cart.yRot)), 0.0, Math.sin(Math.toRadians(cart.yRot))).normalize();
        double product = Math.abs(diffVecN.dot(cartRot));
        if (product < 0.8) {
            return;
        }
        Vec3 cartMotion = cart.getDeltaMovement();
        Vec3 entityMotion = otherCart.getDeltaMovement();
        if (!cart.isPoweredCart() && otherCart.isPoweredCart()) {
            cart.setDeltaMovement(cartMotion.multiply(0.2, 1.0, 0.2));
            cart.push(entityMotion.x - xd, 0.0, entityMotion.z - zd);
            otherCart.setDeltaMovement(entityMotion.multiply(0.95, 1.0, 0.95));
            return;
        }
        if (cart.isPoweredCart() && !otherCart.isPoweredCart()) {
            otherCart.setDeltaMovement(entityMotion.multiply(0.2, 1.0, 0.2));
            otherCart.push(cartMotion.x + xd, 0.0, cartMotion.z + zd);
            cart.setDeltaMovement(cartMotion.multiply(0.95, 1.0, 0.95));
            return;
        }
        double xm = (entityMotion.x + cartMotion.x) / 2.0;
        double zm = (entityMotion.z + cartMotion.z) / 2.0;
        cart.setDeltaMovement(cartMotion.multiply(0.2, 1.0, 0.2));
        cart.push(xm - xd, 0.0, zm - zd);
        otherCart.setDeltaMovement(entityMotion.multiply(0.2, 1.0, 0.2));
        otherCart.push(xm + xd, 0.0, zm + zd);
    }
}

