/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.shulkerboat;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;

public class ShulkerBoatRenderer
extends BoatRenderer {
    private final Map<Boat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(Boat.Type.values()).filter(type -> ResourceLocation.tryParse((String)type.getName()) != null).collect(ImmutableMap.toImmutableMap(type -> type, type -> {
        ResourceLocation resourceId = ResourceLocation.tryParse((String)type.getName());
        if (resourceId == null) {
            throw new IllegalStateException("Could not parse boat type: " + type.getName());
        }
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)resourceId.getNamespace(), (String)("textures/entity/boat/" + resourceId.getPath() + ".png"));
        ModelPart modelPart = context.bakeLayer(ModelLayers.createBoatModelName((Boat.Type)type));
        RaftModel model = type.isRaft() ? new RaftModel(modelPart) : new BoatModel(modelPart);
        return Pair.of((Object)location, (Object)model);
    }));
    private final ShulkerModel<?> shulkerModel;

    public ShulkerBoatRenderer(EntityRendererProvider.Context context) {
        super(context, true);
        this.shulkerModel = new ShulkerModel(context.bakeLayer(ModelLayers.SHULKER));
    }

    public void render(@Nonnull Boat boat, float entityYaw, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight) {
        boolean raft;
        super.render(boat, entityYaw, partialTick, poseStack, buffer, packedLight);
        RenderType renderType = this.shulkerModel.renderType(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/" + Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION.texture().getPath() + ".png")));
        VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float remainingHurtTime = (float)boat.getHurtTime() - partialTick;
        if (remainingHurtTime > 0.0f) {
            float damage = Math.max(0.0f, boat.getDamage() - partialTick);
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)remainingHurtTime) * remainingHurtTime * damage / 10.0f * (float)boat.getHurtDir()));
        }
        poseStack.translate(0.0, (raft = boat.getVariant().isRaft()) ? 1.7 : 1.39, raft ? 0.46 : 0.475);
        poseStack.scale(0.8f, 0.8f, 0.8f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        this.shulkerModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    @Nonnull
    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(@Nonnull Boat boat) {
        return this.boatResources.get(boat.getVariant());
    }
}

