/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.redstone.wireless;

import de.melanx.utilitix.content.redstone.wireless.LinkedCrystalItem;
import de.melanx.utilitix.content.redstone.wireless.LinkedRepeaterBlock;
import de.melanx.utilitix.content.redstone.wireless.WirelessRedstoneSavedData;
import de.melanx.utilitix.registration.ModBlocks;
import de.melanx.utilitix.registration.ModItems;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import org.moddingx.libx.base.tile.BlockEntityBase;

public class LinkedRepeaterBlockEntity
extends BlockEntityBase {
    private ItemStack link = ItemStack.EMPTY;

    public LinkedRepeaterBlockEntity(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
    }

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.link = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Link")).copy();
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Link", this.link.saveOptional(registries));
    }

    public ItemStack getLink() {
        return this.link.copy();
    }

    public void setLink(ItemStack link) {
        UUID oldId = this.getLinkId();
        this.link = link.copy();
        UUID newId = this.getLinkId();
        if (oldId != newId && this.level != null && !this.level.isClientSide) {
            WirelessRedstoneSavedData storage = WirelessRedstoneSavedData.get(this.level);
            storage.remove(this.level, oldId, GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition));
            if (newId != null) {
                storage.update(this.level, newId, GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition), LinkedRepeaterBlock.inputStrength(this.level, this.getBlockState(), this.worldPosition));
            }
            BlockState state = (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.EYE, (Comparable)Boolean.valueOf(newId != null));
            this.level.setBlock(this.worldPosition, state, 3);
            this.level.scheduleTick(this.worldPosition, (Block)ModBlocks.linkedRepeater, 1, TickPriority.EXTREMELY_HIGH);
        }
        this.setChanged();
    }

    @Nullable
    public UUID getLinkId() {
        if (!this.link.isEmpty() && this.link.getItem() == ModItems.linkedCrystal) {
            return LinkedCrystalItem.getId(this.link);
        }
        return null;
    }
}

