/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.redstone;

import de.melanx.utilitix.config.FeatureConfig;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.moddingx.libx.base.BlockBase;
import org.moddingx.libx.mod.ModX;

public class DimmableRedstoneLampBlock
extends BlockBase {
    public static final IntegerProperty SIGNAL = BlockStateProperties.POWER;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> (Integer)state.getValue((Property)SIGNAL);

    public DimmableRedstoneLampBlock(ModX mod, BlockBehaviour.Properties properties) {
        super(mod, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SIGNAL, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)SIGNAL, (Comparable)Integer.valueOf(context.getLevel().getSignal(context.getClickedPos(), context.getClickedFace())));
    }

    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            this.updatePowerStrength(state, level, pos);
        }
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock()) && !level.isClientSide) {
            this.updatePowerStrength(state, level, pos);
        }
    }

    private void updatePowerStrength(BlockState state, Level level, BlockPos pos) {
        boolean hasSignal;
        int signal = level.getBestNeighborSignal(pos);
        boolean bl = hasSignal = (Integer)state.getValue((Property)SIGNAL) > 0;
        if (hasSignal != level.hasNeighborSignal(pos) && hasSignal) {
            level.scheduleTick(pos, (Block)this, 4);
            return;
        }
        if ((Integer)state.getValue((Property)SIGNAL) != signal) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SIGNAL, (Comparable)Integer.valueOf(signal)), 2);
        }
    }

    public void tick(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if ((Integer)state.getValue((Property)SIGNAL) > 0 && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SIGNAL, (Comparable)Integer.valueOf(0)), 2);
        }
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SIGNAL});
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Misc.Redstone.dimmableLamps;
    }
}

