/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.quiver;

import de.melanx.utilitix.content.quiver.QuiverContainer;
import de.melanx.utilitix.content.quiver.QuiverItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.moddingx.libx.menu.MenuBase;
import org.moddingx.libx.menu.type.AdvancedMenuType;

public class QuiverMenu
extends MenuBase {
    private static final int QUIVER_SLOT_COUNT = 9;
    private static final int QUIVER_FIRST_SLOT = 0;
    private static final int PLAYER_FIRST_SLOT = 9;
    public static final AdvancedMenuType<QuiverMenu, InteractionHand> TYPE = AdvancedMenuType.create(QuiverMenu::new, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeEnum, buf -> (InteractionHand)buf.readEnum(InteractionHand.class)));
    private final InteractionHand hand;
    private final ItemStack quiverStack;
    private final QuiverContainer quiverInv;

    public QuiverMenu(@Nullable MenuType<?> type, int windowId, Level level, InteractionHand hand, Player player, Inventory inventory) {
        super(type, windowId, inventory);
        this.hand = hand;
        this.quiverStack = player.getItemInHand(hand);
        QuiverContainer inv = QuiverItem.getInventory(this.quiverStack);
        if (inv == null) {
            throw new IllegalStateException("Tried to open quiver menu without a valid quiver stack.");
        }
        this.quiverInv = inv;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new ArrowSlot(this.quiverInv, i, 8 + i * 18, 18));
        }
        this.layoutPlayerInventorySlots(8, 50);
    }

    public static void open(ServerPlayer player, InteractionHand hand) {
        TYPE.open(player, (Component)Component.translatable((String)"screen.utilitix.quiver"), (Object)hand);
    }

    public ItemStack getQuiverStack() {
        return this.quiverStack;
    }

    public boolean stillValid(@Nonnull Player player) {
        return player.isAlive() && player.getItemInHand(this.hand) == this.quiverStack;
    }

    public void removed(@Nonnull Player player) {
        super.removed(player);
        this.quiverInv.setChanged();
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = slot.getItem();
        ItemStack copy = slotStack.copy();
        if (index < 9 ? !this.moveItemStackTo(slotStack, 9, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, 9, false)) {
            return ItemStack.EMPTY;
        }
        if (slotStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return copy;
    }

    public void clicked(int slotId, int button, @Nonnull ClickType clickType, @Nonnull Player player) {
        if (slotId >= 0 && slotId < this.slots.size() && player.getItemInHand(this.hand) == this.getSlot(slotId).getItem()) {
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    private static class ArrowSlot
    extends Slot {
        public ArrowSlot(QuiverContainer container, int slot, int x, int y) {
            super((Container)container, slot, x, y);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return stack.is(ItemTags.ARROWS);
        }
    }
}

