/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.glue;

import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.utilitix.config.ClientConfig;
import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.glue.StickyChunk;
import de.melanx.utilitix.registration.ModAttachmentTypes;
import de.melanx.utilitix.util.Textures;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.moddingx.libx.render.RenderHelperBlock;
import org.moddingx.libx.render.RenderHelperLevel;

public class StickyRenderHelper {
    public static void renderWorld(RenderLevelStageEvent event) {
        if (!ClientConfig.renderGlueOnBlocks || !FeatureConfig.Misc.InWorldChanges.glue) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        Minecraft.getInstance().getProfiler().push("utilitix_glue");
        Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
        TextureAtlasSprite slime = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(Textures.GLUE_OVERLAY_TEXTURE);
        if (slime == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Frustum clip = event.getFrustum();
        int size = level.getChunkSource().storage.chunks.length();
        Vec3 projection = event.getCamera().getPosition();
        clip.prepare(projection.x, projection.y, projection.z);
        Minecraft.getInstance().getProfiler().push("render_chunks");
        for (int i = 0; i < size; ++i) {
            StickyChunk data;
            ChunkPos pos;
            LevelChunk chunk = (LevelChunk)level.getChunkSource().storage.chunks.get(i);
            if (chunk == null || !clip.isVisible(new AABB((double)(pos = chunk.getPos()).getMinBlockX(), (double)level.getMinBuildHeight(), (double)pos.getMinBlockZ(), (double)(pos.getMaxBlockX() + 1), (double)(level.getMaxBuildHeight() + 1), (double)(pos.getMaxBlockZ() + 1))) || (data = (StickyChunk)chunk.getExistingDataOrNull(ModAttachmentTypes.stickyChunk)) == null) continue;
            data.foreach(StickyRenderHelper.renderChunk(event.getCamera(), clip, poseStack, pos, chunk, slime));
        }
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().pop();
    }

    private static StickyChunk.ChunkAction renderChunk(Camera camera, Frustum clip, PoseStack poseStack, ChunkPos pos, LevelChunk chunk, TextureAtlasSprite slime) {
        return (sectionId, sectionOffset) -> {
            if (clip.isVisible(new AABB((double)pos.getMinBlockX(), (double)sectionOffset, (double)pos.getMinBlockZ(), (double)(pos.getMaxBlockX() + 1), (double)(sectionOffset + 16), (double)(pos.getMaxBlockZ() + 1)))) {
                return StickyRenderHelper.renderSection(camera, poseStack, pos, sectionOffset, chunk, slime);
            }
            return null;
        };
    }

    private static StickyChunk.SectionAction renderSection(final Camera camera, final PoseStack poseStack, final ChunkPos pos, final int sectionOffset, final LevelChunk chunk, final TextureAtlasSprite slime) {
        return new StickyChunk.SectionAction(){

            @Override
            public void start() {
                poseStack.pushPose();
                RenderHelperLevel.loadCameraPosition((Camera)camera, (PoseStack)poseStack, (double)pos.getMinBlockX(), (double)sectionOffset, (double)pos.getMinBlockZ());
                Minecraft.getInstance().getProfiler().push("render_chunk_glue");
            }

            @Override
            public void accept(int x, int y, int z, byte data) {
                Minecraft.getInstance().getProfiler().push("do_render");
                BlockPos block = new BlockPos(pos.getMinBlockX() + x, sectionOffset + y, pos.getMinBlockZ() + z);
                BlockState state = chunk.getBlockState(block);
                int lightValue = state.getLightBlock((BlockGetter)chunk, block);
                int light = LightTexture.pack((int)lightValue, (int)lightValue);
                poseStack.pushPose();
                poseStack.translate((float)x, (float)y, (float)z);
                RenderHelperBlock.renderBlockOverlaySprite((BlockState)state, (PoseStack)poseStack, (int)light, (int)OverlayTexture.NO_OVERLAY, (TextureAtlasSprite)slime, (long)state.getSeed(block), dir -> {
                    if ((data & 1 << dir.ordinal()) == 0) {
                        return false;
                    }
                    BlockPos neighborPos = block.relative(dir);
                    BlockState neighbor = chunk.getBlockState(neighborPos);
                    if (state.skipRendering(neighbor, dir)) {
                        return false;
                    }
                    return Block.shouldRenderFace((BlockState)state, (BlockGetter)chunk, (BlockPos)block, (Direction)dir, (BlockPos)neighborPos);
                });
                poseStack.popPose();
                Minecraft.getInstance().getProfiler().pop();
            }

            @Override
            public void stop() {
                Minecraft.getInstance().getProfiler().pop();
                poseStack.popPose();
            }
        };
    }
}

