/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.glue;

import de.melanx.utilitix.compat.zeta.ZetaCompat;
import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.glue.StickyChunk;
import de.melanx.utilitix.registration.ModAttachmentTypes;
import de.melanx.utilitix.registration.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;

public class GlueBallItem
extends ItemBase {
    public GlueBallItem(ModX mod, Item.Properties properties) {
        super(mod, properties);
        NeoForge.EVENT_BUS.addListener(GlueBallItem::neighbourChange);
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        Direction face;
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        LevelChunk chunk = level.getChunkAt(clickedPos);
        StickyChunk glue = (StickyChunk)chunk.getData(ModAttachmentTypes.stickyChunk);
        int x = clickedPos.getX() & 0xF;
        int y = clickedPos.getY();
        int z = clickedPos.getZ() & 0xF;
        Direction direction = face = context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? context.getClickedFace().getOpposite() : context.getClickedFace();
        if (glue.get(x, y, z, face) || !GlueBallItem.canGlue(level, clickedPos, face)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            glue.attach(chunk);
            glue.set(x, y, z, face, true);
            chunk.setUnsaved(true);
            if (context.getPlayer() == null || !context.getPlayer().getAbilities().instabuild) {
                context.getItemInHand().shrink(1);
            }
            level.playSound(null, clickedPos, SoundEvents.PARROT_IMITATE_SLIME, SoundSource.BLOCKS);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ITEM_SLIME, (double)clickedPos.getX() + 0.5 + 0.55 * (double)face.getStepX(), (double)clickedPos.getY() + 0.5 + 0.55 * (double)face.getStepY(), (double)clickedPos.getZ() + 0.5 + 0.55 * (double)face.getStepZ(), 10, 0.0, 0.0, 0.0, 0.1);
        }
        return super.useOn(context);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        Component warning;
        if (ModList.get().isLoaded("zeta") && (warning = ZetaCompat.warningForGlue()) != null) {
            tooltipComponents.add(warning);
        }
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Misc.InWorldChanges.glue;
    }

    public static void neighbourChange(BlockEvent.NeighborNotifyEvent event) {
        Direction[] directionArray;
        if (event.getLevel().isClientSide() || !((directionArray = event.getLevel()) instanceof Level)) {
            return;
        }
        Level level = (Level)directionArray;
        for (Direction dir : Direction.values()) {
            BlockPos thePos = event.getPos().relative(dir);
            BlockState state = level.getBlockState(thePos);
            if (state.getBlock() == Blocks.MOVING_PISTON && (state.getValue((Property)BlockStateProperties.FACING) == dir || state.getValue((Property)BlockStateProperties.FACING) == dir.getOpposite())) {
                return;
            }
            if (state.getBlock() != Blocks.PISTON_HEAD || !((Boolean)state.getValue((Property)BlockStateProperties.SHORT)).booleanValue() || state.getValue((Property)BlockStateProperties.FACING) != dir && state.getValue((Property)BlockStateProperties.FACING) != dir.getOpposite()) continue;
            return;
        }
        LevelChunk chunk = level.getChunkAt(event.getPos());
        StickyChunk glue = (StickyChunk)chunk.getExistingDataOrNull(ModAttachmentTypes.stickyChunk);
        if (glue == null) {
            return;
        }
        int x = event.getPos().getX() & 0xF;
        int y = event.getPos().getY();
        int z = event.getPos().getZ() & 0xF;
        for (Direction dir : Direction.values()) {
            if (!glue.get(x, y, z, dir) || GlueBallItem.canGlue(level, event.getPos(), dir)) continue;
            glue.set(x, y, z, dir, false);
            chunk.setUnsaved(true);
            BlockPos targetPos = event.getPos().relative(dir);
            ItemEntity ie = new ItemEntity(level, (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.glueBall));
            ie.setPickUpDelay(20);
            level.addFreshEntity((Entity)ie);
        }
    }

    public static boolean canGlue(Level level, BlockPos pos, Direction side) {
        BlockState state = level.getBlockState(pos);
        return FeatureConfig.Misc.InWorldChanges.glue && state.isFaceSturdy((BlockGetter)level, pos, side) && !state.isStickyBlock() && state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f;
    }
}

