/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.experiencecrystal;

import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.experiencecrystal.ExperienceCrystalBlockEntity;
import de.melanx.utilitix.content.experiencecrystal.ExperienceCrystalMenu;
import de.melanx.utilitix.util.XPUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.moddingx.libx.base.tile.MenuBlockBE;
import org.moddingx.libx.block.DirectionShape;
import org.moddingx.libx.mod.ModX;

public class ExperienceCrystalBlock
extends MenuBlockBE<ExperienceCrystalBlockEntity, ExperienceCrystalMenu> {
    private static final VoxelShape BASE_SHAPE = Shapes.or((VoxelShape)ExperienceCrystalBlock.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{ExperienceCrystalBlock.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), ExperienceCrystalBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), ExperienceCrystalBlock.box((double)9.0, (double)6.5, (double)5.0, (double)11.0, (double)11.0, (double)7.0), ExperienceCrystalBlock.box((double)8.5, (double)5.5, (double)4.5, (double)11.5, (double)6.5, (double)7.5), ExperienceCrystalBlock.box((double)8.0, (double)5.5, (double)8.0, (double)12.0, (double)9.5, (double)12.0), ExperienceCrystalBlock.box((double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)12.0, (double)8.0), ExperienceCrystalBlock.box((double)5.0, (double)7.5, (double)9.0, (double)7.0, (double)13.0, (double)11.0), ExperienceCrystalBlock.box((double)4.5, (double)5.5, (double)8.5, (double)7.5, (double)7.5, (double)11.5)});
    private static final DirectionShape SHAPE = new DirectionShape(Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)ExperienceCrystalBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0)));
    private static final DirectionShape COLLISION_SHAPE = new DirectionShape(Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)ExperienceCrystalBlock.box((double)1.0, (double)0.05, (double)1.0, (double)15.0, (double)1.0, (double)15.0)));

    public ExperienceCrystalBlock(ModX mod, BlockBehaviour.Properties properties) {
        super(mod, ExperienceCrystalBlockEntity.class, ExperienceCrystalMenu.TYPE, properties);
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExperienceCrystalBlockEntity) {
            ExperienceCrystalBlockEntity crystal = (ExperienceCrystalBlockEntity)blockEntity;
            crystal.setDispatchable();
        }
    }

    public void entityInside(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        int xpValue;
        ExperienceOrb orb;
        block6: {
            block5: {
                if (!(entity instanceof ExperienceOrb)) break block5;
                orb = (ExperienceOrb)entity;
                if (!level.isClientSide) break block6;
            }
            return;
        }
        ExperienceCrystalBlockEntity blockEntity = (ExperienceCrystalBlockEntity)this.getBlockEntity(level, pos);
        int added = blockEntity.addXp(xpValue = orb.value);
        if (added == xpValue) {
            entity.remove(Entity.RemovalReason.KILLED);
        } else {
            orb.value -= added;
        }
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace());
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING});
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE.getShape((Direction)state.getValue((Property)BlockStateProperties.FACING));
    }

    @Nonnull
    public VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return COLLISION_SHAPE.getShape((Direction)state.getValue((Property)BlockStateProperties.FACING));
    }

    private boolean useFluidItem(BlockEntity blockEntity, Player player, InteractionHand hand, Level level, BlockPos pos, BlockHitResult hitResult) {
        Optional handler = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)hitResult.getDirection());
        if (handler.isEmpty()) {
            return false;
        }
        if (player.getItemInHand(hand).isEmpty() && !((IFluidHandler)handler.get()).getFluidInTank(0).isEmpty()) {
            return false;
        }
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, (Direction)hitResult.getDirection());
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (level.isClientSide || !this.useFluidItem(this.getBlockEntity(level, pos), player, hand, level, pos, hitResult)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        if (!stack.has(DataComponents.BLOCK_ENTITY_DATA)) {
            return;
        }
        CustomData blockEntityData = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!blockEntityData.contains("Xp")) {
            return;
        }
        int xp = blockEntityData.copyTag().getInt("Xp");
        if (xp <= 0) {
            return;
        }
        int level = (Integer)XPUtils.getLevelExp(xp).getLeft();
        if (level > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.utilitix.experience_crystal.xp_level", (Object[])new Object[]{level}).withStyle(ChatFormatting.GREEN));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.utilitix.experience_crystal.xp_points", (Object[])new Object[]{xp}).withStyle(ChatFormatting.GREEN));
        }
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Machines.experienceCrystal;
    }
}

