/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.bell;

import de.melanx.utilitix.config.CommonConfig;
import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.data.enchantments.EnchantmentProvider;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.ModList;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;

public abstract class BellBase
extends ItemBase {
    public BellBase(ModX mod, Item.Properties properties) {
        super(mod, properties);
    }

    public void onStopUsing(@Nonnull ItemStack stack, @Nonnull LivingEntity entity, int count) {
        if (count % 4 != 0) {
            return;
        }
        boolean ringed = this.tryRinging(entity, stack);
        if (ringed && entity instanceof Player) {
            Player player = (Player)entity;
            player.awardStat(Stats.BELL_RING);
        }
    }

    public void onUseTick(@Nonnull Level level, @Nonnull LivingEntity livingEntity, @Nonnull ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration % 4 != 0 || remainingUseDuration == 0) {
            return;
        }
        level.playSound(null, livingEntity.blockPosition(), SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
    }

    public int getUseDuration(@Nonnull ItemStack stack, @Nonnull LivingEntity entity) {
        return CommonConfig.HandBells.ringTime;
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entityLiving) {
        Holder bellRangeEnchantmentHolder = level.registryAccess().holderOrThrow(EnchantmentProvider.BELL_RANGE);
        double range = (double)CommonConfig.HandBells.glowRadius * (1.0 + (double)stack.getEnchantmentLevel(bellRangeEnchantmentHolder) * 0.25);
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(entityLiving.getX() - range, entityLiving.getY() - range, entityLiving.getZ() - range, entityLiving.getX() + range, entityLiving.getY() + range, entityLiving.getZ() + range), livingEntity -> this.entityFilter((LivingEntity)livingEntity, stack));
        entities.forEach(entity -> entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, CommonConfig.HandBells.glowTime)));
        return super.finishUsingItem(stack, level, entityLiving);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean tryRinging(LivingEntity entity, ItemStack stack) {
        Level level = entity.getCommandSenderWorld();
        BlockPos pos = entity.blockPosition();
        if (level.isClientSide) {
            return false;
        }
        if (this.notifyNearbyEntities()) {
            Holder bellRangeEnchantmentHolder = level.registryAccess().holderOrThrow(EnchantmentProvider.BELL_RANGE);
            double range = (double)CommonConfig.HandBells.notifyRadius * (1.0 + (double)stack.getEnchantmentLevel(bellRangeEnchantmentHolder) * 0.25);
            List entities = entity.getCommandSenderWorld().getEntitiesOfClass(LivingEntity.class, new AABB(entity.getX() - range, entity.getY() - range, entity.getZ() - range, entity.getX() + range, entity.getY() + range, entity.getZ() + range));
            entities.forEach(e -> e.getBrain().setMemory(MemoryModuleType.HEARD_BELL_TIME, (Object)level.getGameTime()));
        }
        level.playSound(null, pos, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
        return true;
    }

    protected abstract boolean entityFilter(LivingEntity var1, ItemStack var2);

    protected abstract boolean notifyNearbyEntities();

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (ModList.get().isLoaded("emojiful")) {
            tooltipComponents.add((Component)Component.literal((String)":DinkDonk:"));
        }
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Items.handBells;
    }
}

