/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.registration.ModDataComponentTypes;
import de.melanx.utilitix.util.MobData;
import de.melanx.utilitix.util.MobUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;

public class MobYoinkerItem
extends ItemBase {
    public MobYoinkerItem(Item.Properties properties) {
        super((ModX)UtilitiX.getInstance(), properties);
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        InteractionHand hand = context.getHand();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        MobData mobData = (MobData)stack.get(ModDataComponentTypes.mobData);
        if (mobData == null) {
            return super.useOn(context);
        }
        Optional entityType = EntityType.byString((String)mobData.entityType());
        if (entityType.isEmpty()) {
            MobYoinkerItem.reset(stack);
            return super.useOn(context);
        }
        Entity mob = ((EntityType)entityType.get()).create(player.level());
        if (mob == null) {
            MobYoinkerItem.reset(stack);
            return InteractionResult.PASS;
        }
        mob.load(mobData.entityData());
        mob.setPos(context.getClickLocation());
        if (player.level().addFreshEntity(mob)) {
            MobYoinkerItem.reset(stack);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int slotId, boolean isSelected) {
        boolean filled = MobUtil.getCurrentMob(stack) != null;
        stack.set(ModDataComponentTypes.filled, (Object)filled);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        MutableComponent component = MobUtil.getCurrentMob(stack);
        tooltipComponents.add((Component)(component != null ? component : MobUtil.NO_MOB));
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Items.mobYoinker;
    }

    private static void reset(ItemStack stack) {
        stack.remove(ModDataComponentTypes.mobData);
    }

    public static enum ExperienceMode {
        LEVEL,
        POINTS;

    }
}

