/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jei;

import de.melanx.utilitix.compat.jei.UtiliJei;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class GildingCategory
implements IRecipeCategory<SmithingTransformRecipe> {
    private final IDrawable icon;

    public GildingCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.SMITHING_TABLE));
    }

    @Nonnull
    public RecipeType<SmithingTransformRecipe> getRecipeType() {
        return UtiliJei.GILDING_RECIPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.utilitix.gilding");
    }

    public int getWidth() {
        return 108;
    }

    public int getHeight() {
        return 28;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull SmithingTransformRecipe recipe, @Nonnull IFocusGroup focuses) {
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        builder.addInputSlot(1, 6).setStandardSlotBackground();
        IRecipeSlotBuilder baseSlot = builder.addInputSlot(19, 6).setStandardSlotBackground();
        IRecipeSlotBuilder additionSlot = builder.addInputSlot(37, 6).setStandardSlotBackground();
        IRecipeSlotBuilder outputSlot = builder.addOutputSlot(91, 6).setStandardSlotBackground();
        baseSlot.addIngredients(recipeHelper.getBase((SmithingRecipe)recipe));
        additionSlot.addIngredients(recipeHelper.getAddition((SmithingRecipe)recipe));
        outputSlot.addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }
}

