/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.recipe.brewery;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.utilitix.recipe.PotionInput;
import de.melanx.utilitix.recipe.PotionOutput;
import de.melanx.utilitix.recipe.brewery.EffectTransformer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;

public class Upgrade
extends EffectTransformer {
    public static final MapCodec<Upgrade> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)255).fieldOf("max_level").forGetter(transformer -> transformer.maxLevel + 1)).apply((Applicative)instance, maxLevelOneBased -> new Upgrade(Math.max(0, maxLevelOneBased - 1))));
    public static final StreamCodec<RegistryFriendlyByteBuf, Upgrade> STREAM_CODEC = StreamCodec.of((buffer, value) -> buffer.writeVarInt(value.maxLevel), buffer -> new Upgrade(buffer.readVarInt()));
    private final int maxLevel;

    public Upgrade(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    @Override
    public boolean canTransform(PotionInput input) {
        return input.getIn1().isEmpty() && input.getIn2().isEmpty() && input.testEffectsMain(potionContents -> {
            List<MobEffectInstance> effects = this.getEffects((PotionContents)potionContents);
            return effects.size() == 1 && effects.getFirst().getAmplifier() < this.maxLevel;
        });
    }

    @Override
    public ItemStack output() {
        return new ItemStack((ItemLike)Items.POTION);
    }

    @Override
    @Nullable
    public PotionOutput transform(PotionInput input) {
        if (input.getEffectsMain() == null) {
            return null;
        }
        List<MobEffectInstance> effects = this.getEffects(input.getEffectsMain());
        if (effects.isEmpty()) {
            return null;
        }
        MobEffectInstance old = effects.getFirst();
        ItemStack newStack = EffectTransformer.create(input.getMain().getItem(), (List<MobEffectInstance>)ImmutableList.of((Object)new MobEffectInstance(old.getEffect(), old.getDuration(), Mth.clamp((int)(old.getAmplifier() + 1), (int)0, (int)this.maxLevel), old.isAmbient(), old.isVisible())));
        newStack.set(DataComponents.CUSTOM_NAME, (Object)input.getMain().getHoverName());
        return PotionOutput.simple(newStack);
    }
}

