/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.recipe.brewery;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.utilitix.recipe.PotionInput;
import de.melanx.utilitix.recipe.PotionOutput;
import de.melanx.utilitix.recipe.brewery.EffectTransformer;
import de.melanx.utilitix.registration.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;

public class Merge
extends EffectTransformer {
    public static final MapCodec<Merge> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("fail_multiplier").forGetter(Merge::getFailMultiplier)).apply((Applicative)instance, Merge::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Merge> STREAM_CODEC = StreamCodec.of((buffer, value) -> buffer.writeFloat(value.getFailMultiplier()), buffer -> new Merge(buffer.readFloat()));
    private final float failMultiplier;

    public Merge(float failMultiplier) {
        this.failMultiplier = failMultiplier;
    }

    @Override
    public boolean canTransform(PotionInput input) {
        return input.getMain().getItem() == Items.GLASS_BOTTLE && input.getIn1().getItem() == input.getIn2().getItem() && input.testEffects1(potionContents -> !this.getEffects((PotionContents)potionContents).isEmpty()) && input.testEffects2(list -> !this.getEffects((PotionContents)list).isEmpty());
    }

    @Override
    public ItemStack output() {
        return new ItemStack((ItemLike)Items.POTION);
    }

    @Override
    @Nullable
    public PotionOutput transform(PotionInput input) {
        ArrayList<MobEffectInstance> merged = new ArrayList<MobEffectInstance>();
        if (input.getEffects1() != null) {
            for (MobEffectInstance effect : this.getEffects(input.getEffects1())) {
                this.addMergedEffectToList((Holder<MobEffect>)effect.getEffect(), merged, input.getEffects1(), input.getEffects2());
            }
        }
        if (input.getEffects2() != null) {
            for (MobEffectInstance effect : this.getEffects(input.getEffects2())) {
                this.addMergedEffectToList((Holder<MobEffect>)effect.getEffect(), merged, input.getEffects1(), input.getEffects2());
            }
        }
        float chance = (float)Math.max(0, merged.size() + 1) * this.failMultiplier;
        Random random = new Random();
        if ((float)random.nextInt(100) < chance) {
            return PotionOutput.simple(new ItemStack((ItemLike)ModItems.failedPotion));
        }
        ItemStack stack = EffectTransformer.create(input.getIn1().getItem(), merged);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.utilitix.merged_potion").withStyle(ChatFormatting.GREEN));
        return PotionOutput.simple(stack);
    }

    public float getFailMultiplier() {
        return this.failMultiplier;
    }

    private void addMergedEffectToList(Holder<MobEffect> potion, List<MobEffectInstance> mergeList, @Nullable PotionContents potionContents1, @Nullable PotionContents potionContents2) {
        for (MobEffectInstance effect : mergeList) {
            if (effect.getEffect() != potion) continue;
            return;
        }
        MobEffectInstance effect1 = null;
        MobEffectInstance effect2 = null;
        if (potionContents1 != null) {
            for (MobEffectInstance effect : this.getEffects(potionContents1)) {
                if (effect.getEffect() != potion) continue;
                effect1 = effect;
                break;
            }
        }
        if (potionContents2 != null) {
            for (MobEffectInstance effect : this.getEffects(potionContents2)) {
                if (effect.getEffect() != potion) continue;
                effect2 = effect;
                break;
            }
        }
        if (effect1 == null && effect2 == null) {
            return;
        }
        if (effect1 == null) {
            mergeList.add(effect2);
            return;
        }
        if (effect2 == null) {
            mergeList.add(effect1);
            return;
        }
        boolean useFirst = effect1.getAmplifier() != effect2.getAmplifier() ? effect1.getAmplifier() > effect2.getAmplifier() : effect1.getDuration() > effect2.getDuration();
        mergeList.add(useFirst ? effect1 : effect2);
    }
}

