/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.utilitix.recipe.PotionInput;
import de.melanx.utilitix.recipe.PotionOutput;
import de.melanx.utilitix.recipe.brewery.Apply;
import de.melanx.utilitix.recipe.brewery.Clone;
import de.melanx.utilitix.recipe.brewery.EffectTransformer;
import de.melanx.utilitix.recipe.brewery.Merge;
import de.melanx.utilitix.recipe.brewery.Upgrade;
import de.melanx.utilitix.registration.ModRecipeTypes;
import de.melanx.utilitix.registration.ModRecipes;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class BreweryRecipe
implements Recipe<RecipeWrapper> {
    private final Ingredient input;
    private final EffectTransformer transformer;

    public BreweryRecipe(@Nullable Ingredient input, EffectTransformer transformer) {
        this.input = input;
        this.transformer = transformer;
    }

    public boolean matches(@Nonnull RecipeWrapper recipeWrapper, @Nonnull Level level) {
        if (recipeWrapper.size() != 5) {
            return false;
        }
        ItemStack mainInput = recipeWrapper.getItem(0);
        if (this.input == null && !mainInput.isEmpty() || this.input != null && !this.input.test(mainInput)) {
            return false;
        }
        return this.transformer.canTransform(new PotionInput(recipeWrapper.getItem(3), recipeWrapper.getItem(1), recipeWrapper.getItem(2)));
    }

    @Nullable
    public PotionOutput getPotionResult(@Nonnull RecipeWrapper recipeWrapper) {
        if (recipeWrapper.size() != 5) {
            return null;
        }
        return this.transformer.transform(new PotionInput(recipeWrapper.getItem(3), recipeWrapper.getItem(1), recipeWrapper.getItem(2)));
    }

    @Nonnull
    public ItemStack assemble(@Nonnull RecipeWrapper recipeWrapper, @Nonnull HolderLookup.Provider registry) {
        PotionOutput output = this.getPotionResult(recipeWrapper);
        return output == null ? recipeWrapper.getItem(3).copy() : output.getMain();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registry) {
        return this.transformer.output();
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        if (this.input != null) {
            list.add((Object)this.input);
        }
        return list;
    }

    public boolean isSpecial() {
        return true;
    }

    public EffectTransformer getAction() {
        return this.transformer;
    }

    @Nonnull
    public RecipeType<?> getType() {
        return ModRecipeTypes.BREWERY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.brewerySerializer;
    }

    public Optional<Ingredient> getInput() {
        return Optional.ofNullable(this.input);
    }

    public static class Serializer
    implements RecipeSerializer<BreweryRecipe> {
        private static final MapCodec<EffectTransformer> ACTION_CODEC = Codec.STRING.dispatchMap("type", Serializer::actionType, Serializer::actionCodec);
        private static final Codec<EffectTransformer> DIRECT_ACTION_CODEC = ACTION_CODEC.codec();
        private static final StreamCodec<RegistryFriendlyByteBuf, EffectTransformer> ACTION_STREAM_CODEC = StreamCodec.of(Serializer::toNetworkAction, Serializer::fromNetworkAction);
        public static final MapCodec<BreweryRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.optionalFieldOf("input").forGetter(BreweryRecipe::getInput), (App)DIRECT_ACTION_CODEC.fieldOf("action").forGetter(BreweryRecipe::getAction)).apply((Applicative)instance, (input, action) -> new BreweryRecipe(input.orElse(null), (EffectTransformer)action)));
        public static final StreamCodec<RegistryFriendlyByteBuf, BreweryRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static <T> MapCodec<T> errorMapCodec(final String message) {
            return new MapCodec<T>(){

                public <U> Stream<U> keys(DynamicOps<U> ops) {
                    return Stream.empty();
                }

                public <U> DataResult<T> decode(DynamicOps<U> ops, MapLike<U> input) {
                    return DataResult.error(() -> message);
                }

                public <U> RecordBuilder<U> encode(T input, DynamicOps<U> ops, RecordBuilder<U> prefix) {
                    return prefix.withErrorsFrom(DataResult.error(() -> message));
                }
            };
        }

        private static String actionType(EffectTransformer transformer) {
            if (transformer instanceof Apply) {
                return "apply";
            }
            if (transformer instanceof Merge) {
                return "merge";
            }
            if (transformer instanceof Upgrade) {
                return "upgrade";
            }
            if (transformer instanceof Clone) {
                return "clone";
            }
            throw new IllegalStateException("Unknown EffectTransformer: " + transformer.getClass().getName());
        }

        private static MapCodec<? extends EffectTransformer> actionCodec(String type) {
            return switch (type.toLowerCase(Locale.ROOT)) {
                case "apply" -> Apply.CODEC;
                case "merge" -> Merge.CODEC;
                case "upgrade" -> Upgrade.CODEC;
                case "clone" -> Clone.CODEC;
                default -> Serializer.errorMapCodec("Unknown effect transformer type: " + type);
            };
        }

        private static EffectTransformer fromNetworkAction(@Nonnull RegistryFriendlyByteBuf buffer) {
            byte id = buffer.readByte();
            return switch (id) {
                case 0 -> (Apply)Apply.STREAM_CODEC.decode((Object)buffer);
                case 1 -> (Merge)Merge.STREAM_CODEC.decode((Object)buffer);
                case 2 -> (Upgrade)Upgrade.STREAM_CODEC.decode((Object)buffer);
                case 3 -> (Clone)Clone.STREAM_CODEC.decode((Object)buffer);
                default -> throw new IllegalStateException("Invalid packet: Unknown effect transformer type: " + id);
            };
        }

        private static void toNetworkAction(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull EffectTransformer transformer) {
            EffectTransformer effectTransformer = transformer;
            Objects.requireNonNull(effectTransformer);
            EffectTransformer effectTransformer2 = effectTransformer;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Apply.class, Merge.class, Upgrade.class, Clone.class}, (Object)effectTransformer2, n)) {
                case 0: {
                    Apply apply = (Apply)effectTransformer2;
                    buffer.writeByte(0);
                    Apply.STREAM_CODEC.encode((Object)buffer, (Object)apply);
                    break;
                }
                case 1: {
                    Merge merge = (Merge)effectTransformer2;
                    buffer.writeByte(1);
                    Merge.STREAM_CODEC.encode((Object)buffer, (Object)merge);
                    break;
                }
                case 2: {
                    Upgrade upgrade = (Upgrade)effectTransformer2;
                    buffer.writeByte(2);
                    Upgrade.STREAM_CODEC.encode((Object)buffer, (Object)upgrade);
                    break;
                }
                case 3: {
                    Clone clone = (Clone)effectTransformer2;
                    buffer.writeByte(3);
                    Clone.STREAM_CODEC.encode((Object)buffer, (Object)clone);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown EffectTransformer: " + transformer.getClass().getName());
                }
            }
        }

        public static BreweryRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            Ingredient input = null;
            if (buffer.readBoolean()) {
                input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            }
            EffectTransformer transformer = (EffectTransformer)ACTION_STREAM_CODEC.decode((Object)buffer);
            return new BreweryRecipe(input, transformer);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull BreweryRecipe recipe) {
            buffer.writeBoolean(recipe.input != null);
            if (recipe.input != null) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            }
            ACTION_STREAM_CODEC.encode((Object)buffer, (Object)recipe.transformer);
        }

        @Nonnull
        public MapCodec<BreweryRecipe> codec() {
            return CODEC;
        }

        @Nonnull
        public StreamCodec<RegistryFriendlyByteBuf, BreweryRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

