/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.network.handler;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.experiencecrystal.ExperienceCrystalBlockEntity;
import de.melanx.utilitix.content.experiencecrystal.ExperienceCrystalScreen;
import de.melanx.utilitix.util.XPUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class ClickScreenButton
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(UtilitiX.getInstance().resource("click_screen_button"));

    public ClickScreenButton() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)player2.level();
        ExperienceCrystalScreen.Button button = msg.button;
        BlockEntity blockEntity = level.getBlockEntity(msg.pos);
        Holder mending = level.registryAccess().holderOrThrow(Enchantments.MENDING);
        if (!(blockEntity instanceof ExperienceCrystalBlockEntity)) {
            return;
        }
        ExperienceCrystalBlockEntity experienceCrystalBlockEntity = (ExperienceCrystalBlockEntity)blockEntity;
        int playerXP = XPUtils.getExpPoints(player2.experienceLevel, player2.experienceProgress);
        switch (button) {
            case ADD_ONE: {
                ClickScreenButton.normalizeAddition((Player)player2, experienceCrystalBlockEntity);
                int xp = XPUtils.getXpBarCap(player2.experienceLevel - 1);
                int i = experienceCrystalBlockEntity.addXp(xp);
                player2.giveExperiencePoints(-i);
                break;
            }
            case ADD_TEN: {
                int i;
                ClickScreenButton.normalizeAddition((Player)player2, experienceCrystalBlockEntity);
                int xp = 0;
                for (i = 0; i < 10; ++i) {
                    xp += XPUtils.getXpBarCap(player2.experienceLevel - 1 - i);
                }
                i = experienceCrystalBlockEntity.addXp(xp);
                player2.giveExperiencePoints(-i);
                break;
            }
            case ADD_ALL: {
                int xp = experienceCrystalBlockEntity.addXp(playerXP < 0 ? Integer.MAX_VALUE : playerXP);
                player2.giveExperiencePoints(-xp);
                break;
            }
            case SUB_ONE: {
                ClickScreenButton.normalizeSubtraction((Player)player2, experienceCrystalBlockEntity, 1);
                break;
            }
            case SUB_TEN: {
                ClickScreenButton.normalizeSubtraction((Player)player2, experienceCrystalBlockEntity, 10);
                break;
            }
            case SUB_ALL: {
                int xp = experienceCrystalBlockEntity.subtractXp(Integer.MAX_VALUE);
                player2.giveExperiencePoints(xp);
                break;
            }
            case REPAIR_ONE: {
                ItemStack mainHandItem = player2.getMainHandItem();
                ClickScreenButton.repairItem(experienceCrystalBlockEntity, mainHandItem, (Holder<Enchantment>)mending);
                break;
            }
            case REPAIR_ALL: {
                for (int i = 0; i < player2.getInventory().getContainerSize(); ++i) {
                    ItemStack stack = player2.getInventory().getItem(i);
                    ClickScreenButton.repairItem(experienceCrystalBlockEntity, stack, (Holder<Enchantment>)mending);
                }
                break;
            }
        }
    }

    private static void normalizeAddition(Player player, ExperienceCrystalBlockEntity blockEntity) {
        int transfer = (int)(player.experienceProgress * (float)player.getXpNeededForNextLevel());
        int i = blockEntity.addXp(transfer);
        player.giveExperiencePoints(-i);
    }

    private static void normalizeSubtraction(Player player, ExperienceCrystalBlockEntity blockEntity, int levels) {
        int newV = XPUtils.getExpPoints(player.experienceLevel + levels, 0.0f);
        int oldV = XPUtils.getExpPoints(player.experienceLevel, player.experienceProgress);
        int xp = newV - oldV;
        int i = blockEntity.subtractXp(xp);
        player.giveExperiencePoints(i);
        if (Math.round(player.experienceProgress) == 1) {
            i = blockEntity.subtractXp(1);
            player.giveExperiencePoints(i);
        }
    }

    private static void repairItem(ExperienceCrystalBlockEntity blockEntity, ItemStack stack, Holder<Enchantment> mending) {
        if (stack.getEnchantmentLevel(mending) > 0 && stack.isDamaged()) {
            int damageValue = (int)((float)stack.getDamageValue() * stack.getXpRepairRatio());
            int toRemove = blockEntity.subtractXp(damageValue);
            stack.setDamageValue(stack.getDamageValue() - toRemove);
        }
    }

    public record Message(BlockPos pos, ExperienceCrystalScreen.Button button) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeBlockPos(msg.pos);
            buffer.writeEnum((Enum)msg.button);
        }, buffer -> new Message(buffer.readBlockPos(), (ExperienceCrystalScreen.Button)buffer.readEnum(ExperienceCrystalScreen.Button.class)));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

