/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.shulkerboat;

import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.shulkerboat.ShulkerBoat;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;

public class ShulkerBoatItem
extends ItemBase {
    private final Boat.Type boatType;

    public ShulkerBoatItem(ModX mod, Boat.Type boatType, Item.Properties properties) {
        super(mod, properties);
        this.boatType = boatType;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hitResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)stack);
        }
        Vec3 view = player.getViewVector(1.0f);
        List entities = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(view.scale(5.0)).inflate(1.0), EntitySelector.NO_SPECTATORS.and(Entity::isPickable));
        if (!entities.isEmpty()) {
            Vec3 eyePos = player.getEyePosition();
            for (Entity entity : entities) {
                AABB box = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!box.contains(eyePos)) continue;
                return InteractionResultHolder.pass((Object)stack);
            }
        }
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ShulkerBoat boat = new ShulkerBoat(level, hitResult.getLocation());
        boat.setVariant(this.boatType);
        boat.setYRot(player.getYRot());
        if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide) {
            if (stack.has(DataComponents.CONTAINER)) {
                ItemContainerContents itemContainerContents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
                itemContainerContents.copyInto(boat.getItemStacks());
            }
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                boat.setCustomName(stack.getHoverName());
            }
            level.addFreshEntity((Entity)boat);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitResult.getLocation());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    public boolean canFitInsideContainerItems(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Transportation.shulkerBoats;
    }
}

