/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.shulkerboat;

import de.melanx.utilitix.registration.ModEntities;
import de.melanx.utilitix.registration.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class ShulkerBoat
extends ChestBoat {
    public ShulkerBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public ShulkerBoat(Level level, Vec3 pos) {
        this(ModEntities.shulkerBoat, level);
        this.setPos(pos);
        this.xo = pos.x;
        this.yo = pos.y;
        this.zo = pos.z;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
        if (this.getLootTable() != null && player.isSpectator()) {
            return null;
        }
        this.unpackLootTable(player);
        return new ShulkerBoxMenu(id, inventory, (Container)this);
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurt(@Nonnull DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + amount * 10.0f);
        this.markHurt();
        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
        var5_3 = source.getEntity();
        if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
        player = (Player)var5_3;
        if (player.getAbilities().instabuild) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = creative = false;
        }
        if (creative || this.getDamage() > 40.0f) {
            if ((!creative || this.hasItems()) && (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) || this.hasItems())) {
                this.destroy(source);
            }
            this.discard();
        }
        return true;
    }

    private boolean hasItems() {
        for (ItemStack item : this.getItemStacks()) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Item getDropItem() {
        return switch (this.getVariant()) {
            case Boat.Type.SPRUCE -> ModItems.spruceShulkerBoat;
            case Boat.Type.BIRCH -> ModItems.birchShulkerBoat;
            case Boat.Type.JUNGLE -> ModItems.jungleShulkerBoat;
            case Boat.Type.ACACIA -> ModItems.acaciaShulkerBoat;
            case Boat.Type.CHERRY -> ModItems.cherryShulkerBoat;
            case Boat.Type.DARK_OAK -> ModItems.darkOakShulkerBoat;
            case Boat.Type.MANGROVE -> ModItems.mangroveShulkerBoat;
            case Boat.Type.BAMBOO -> ModItems.bambooShulkerRaft;
            default -> ModItems.oakShulkerBoat;
        };
    }

    public void destroy(@Nonnull DamageSource source) {
        ItemStack drop = new ItemStack((ItemLike)this.getDropItem());
        ItemContainerContents containerContents = ItemContainerContents.fromItems((List)this.getItemStacks());
        if (containerContents != ItemContainerContents.EMPTY) {
            drop.set(DataComponents.CONTAINER, (Object)containerContents);
        }
        if (this.hasCustomName()) {
            drop.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        this.spawnAtLocation(drop);
    }

    @Nonnull
    public ItemStack getPickResult() {
        ItemStack stack = new ItemStack((ItemLike)this.getDropItem());
        ItemContainerContents containerContents = ItemContainerContents.fromItems((List)this.getItemStacks());
        if (containerContents != ItemContainerContents.EMPTY) {
            stack.set(DataComponents.CONTAINER, (Object)containerContents);
        }
        return stack;
    }

    public void remove(@Nonnull Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason.shouldDestroy() && this.isLeashed()) {
            this.dropLeash(true, true);
        }
        this.setRemoved(reason);
    }
}

