/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.redstone.wireless;

import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.redstone.wireless.LinkedCrystalItem;
import de.melanx.utilitix.content.redstone.wireless.LinkedRepeaterBlockEntity;
import de.melanx.utilitix.content.redstone.wireless.LinkedRepeaterRenderer;
import de.melanx.utilitix.content.redstone.wireless.WirelessRedstoneSavedData;
import de.melanx.utilitix.registration.ModItems;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.moddingx.libx.base.tile.BlockBE;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.SetupContext;

public class LinkedRepeaterBlock
extends BlockBE<LinkedRepeaterBlockEntity> {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public LinkedRepeaterBlock(ModX mod, BlockBehaviour.Properties properties) {
        this(mod, properties, new Item.Properties());
    }

    public LinkedRepeaterBlock(ModX mod, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, LinkedRepeaterBlockEntity.class, properties, itemProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.EYE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupClient(SetupContext ctx) {
        ctx.enqueue(() -> BlockEntityRenderers.register((BlockEntityType)this.getBlockEntityType(), context -> new LinkedRepeaterRenderer()));
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.EYE, BlockStateProperties.POWER});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.EYE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(0));
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        LinkedRepeaterBlockEntity blockEntity = (LinkedRepeaterBlockEntity)this.getBlockEntity(level, pos);
        ItemStack link = blockEntity.getLink();
        if (!link.isEmpty()) {
            ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, link.copy());
            level.addFreshEntity((Entity)entity);
            blockEntity.setLink(ItemStack.EMPTY);
            return ItemInteractionResult.CONSUME;
        }
        ItemStack held = player.getItemInHand(hand);
        if (!held.isEmpty() && held.getItem() == ModItems.linkedCrystal && LinkedCrystalItem.getId(held) != null) {
            blockEntity.setLink(held.split(1));
            player.setItemInHand(hand, held);
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.FAIL;
    }

    public void onRemove(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!(!state.hasBlockEntity() || state.is(newState.getBlock()) && newState.hasBlockEntity())) {
            LinkedRepeaterBlockEntity blockEntity = (LinkedRepeaterBlockEntity)this.getBlockEntity(level, pos);
            WirelessRedstoneSavedData.get(level).remove(level, blockEntity.getLinkId(), GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos));
            ItemStack stack = blockEntity.getLink();
            if (!stack.isEmpty()) {
                ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, stack.copy());
                level.addFreshEntity((Entity)entity);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
        this.notifyNeighbors(level, pos, state);
    }

    protected boolean shouldDropInventory(Level level, BlockPos pos, BlockState state) {
        return false;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.below());
    }

    public int getDirectSignal(BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return blockState.getSignal(blockAccess, pos, side);
    }

    public int getSignal(BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == side ? (Integer)blockState.getValue((Property)BlockStateProperties.POWER) : 0;
    }

    public void neighborChanged(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (state.canSurvive((LevelReader)level, pos)) {
            this.updateState(level, pos, state);
            return;
        }
        level.removeBlock(pos, false);
        for (Direction direction : Direction.values()) {
            level.updateNeighborsAt(pos.relative(direction), (Block)this);
        }
    }

    public boolean isSignalSource(@Nonnull BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable Direction direction) {
        return this.isSignalSource(state) && direction != null && direction.getAxis() == ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis();
    }

    public void setPlacedBy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        if (LinkedRepeaterBlock.inputStrength(level, state, pos) != (Integer)state.getValue((Property)BlockStateProperties.POWER)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        this.notifyNeighbors(level, pos, state);
    }

    private void updateState(Level level, BlockPos pos, BlockState state) {
        if (level.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            return;
        }
        TickPriority priority = TickPriority.HIGH;
        Block targetBlock = level.getBlockState(pos.relative((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))).getBlock();
        if (targetBlock instanceof DiodeBlock || targetBlock instanceof LinkedRepeaterBlock) {
            priority = TickPriority.EXTREMELY_HIGH;
        }
        level.scheduleTick(pos, (Block)this, 1, priority);
    }

    public void tick(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        int input = LinkedRepeaterBlock.inputStrength((Level)level, state, pos);
        UUID uid = ((LinkedRepeaterBlockEntity)this.getBlockEntity((Level)level, pos)).getLinkId();
        if (uid != null) {
            WirelessRedstoneSavedData storage = WirelessRedstoneSavedData.get((Level)level);
            storage.update((Level)level, uid, GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos), input);
            input = storage.getStrength(uid);
        }
        if (input != (Integer)state.getValue((Property)BlockStateProperties.POWER)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(input)), 2);
        }
    }

    private void notifyNeighbors(Level level, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockPos target = pos.relative(face.getOpposite());
        if (EventHooks.onNeighborNotify((Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos), EnumSet.of(face.getOpposite()), (boolean)false).isCanceled()) {
            return;
        }
        level.neighborChanged(target, (Block)this, pos);
        level.updateNeighborsAtExceptFromFacing(target, (Block)this, face);
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Misc.Redstone.wirelessRedstone;
    }

    public static int inputStrength(Level level, BlockState state, BlockPos pos) {
        Direction face = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockPos targetPos = pos.relative(face);
        int signalStrength = level.getSignal(targetPos, face);
        if (signalStrength >= 15) {
            return 15;
        }
        BlockState targetState = level.getBlockState(targetPos);
        return Math.max(signalStrength, targetState.is(Blocks.REDSTONE_WIRE) ? (Integer)targetState.getValue((Property)BlockStateProperties.POWER) : 0);
    }
}

