/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.redstone.wireless;

import de.melanx.utilitix.config.FeatureConfig;
import de.melanx.utilitix.content.redstone.wireless.WirelessRedstoneSavedData;
import de.melanx.utilitix.registration.ModDataComponentTypes;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;

public class LinkedCrystalItem
extends ItemBase {
    public LinkedCrystalItem(ModX mod, Item.Properties properties) {
        super(mod, properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        UUID uid = LinkedCrystalItem.getId(held);
        if (uid != null) {
            if (!level.isClientSide) {
                WirelessRedstoneSavedData storage = WirelessRedstoneSavedData.get(level);
                int strength = storage.getStrength(uid);
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.utilitix.signal_strength", (Object[])new Object[]{Component.literal((String)Integer.toString(strength)).withStyle(ChatFormatting.RED)}));
            }
            return InteractionResultHolder.sidedSuccess((Object)held, (boolean)level.isClientSide);
        }
        if (held.getCount() < 2) {
            if (level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.utilitix.link_failed"), true);
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)held);
        }
        if (!level.isClientSide) {
            ItemStack stack = held.copy();
            stack.set(ModDataComponentTypes.redstoneId, (Object)UUID.randomUUID());
            player.drop(stack, false);
        }
        player.setItemInHand(hand, ItemStack.EMPTY);
        return InteractionResultHolder.sidedSuccess((Object)ItemStack.EMPTY, (boolean)level.isClientSide);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        UUID uid = LinkedCrystalItem.getId(stack);
        tooltipComponents.add((Component)(uid == null ? Component.translatable((String)"tooltip.utilitix.invalid_link").withStyle(ChatFormatting.RED) : Component.translatable((String)"tooltip.utilitix.valid_link", (Object[])new Object[]{Component.literal((String)uid.toString()).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.RED)));
    }

    @Nullable
    public static UUID getId(ItemStack stack) {
        return (UUID)stack.get(ModDataComponentTypes.redstoneId);
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return FeatureConfig.Misc.Redstone.wirelessRedstone;
    }
}

