/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.glue;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.glue.StickySection;
import de.melanx.utilitix.network.handler.StickyChunkUpdate;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;

public class StickyChunk
implements INBTSerializable<CompoundTag> {
    @Nullable
    private LevelChunk chunk;
    private final Map<Integer, StickySection> sections = new HashMap<Integer, StickySection>();

    public boolean get(int x, int y, int z, Direction dir) {
        StickySection section = this.getSection(y);
        return section != null && section.get(x, y & 0xF, z, dir);
    }

    public boolean getAny(int x, int y, int z) {
        StickySection section = this.getSection(y);
        if (section == null) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            if (!section.get(x, y & 0xF, z, direction)) continue;
            return true;
        }
        return false;
    }

    public void set(int x, int y, int z, Direction dir, boolean sticky) {
        StickySection section = this.getOrCreateSection(y);
        section.set(x, y & 0xF, z, dir, sticky);
    }

    public byte getData(int x, int y, int z) {
        StickySection section = this.getSection(y);
        return section == null ? (byte)0 : section.getData(x, y & 0xF, z);
    }

    public void setData(int x, int y, int z, byte data) {
        StickySection section = this.getOrCreateSection(y);
        section.setData(x, y & 0xF, z, data);
    }

    public void clearData(int x, int y, int z) {
        StickySection section = this.getOrCreateSection(y);
        section.clearData(x, y & 0xF, z);
    }

    public void foreach(ChunkAction action) {
        for (Map.Entry<Integer, StickySection> entry : this.sections.entrySet()) {
            SectionAction sectionAction;
            if (entry.getValue().canBeDiscarded() || (sectionAction = action.section(entry.getKey(), entry.getKey() << 4)) == null) continue;
            entry.getValue().foreach(sectionAction);
        }
    }

    public void sync() {
        if (this.chunk != null && !this.chunk.getLevel().isClientSide) {
            this.chunk.setUnsaved(true);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.chunk.getLevel()), (ChunkPos)this.chunk.getPos(), (CustomPacketPayload)new StickyChunkUpdate.Message(this.chunk.getPos(), this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Nullable
    private StickySection getSection(int y) {
        return this.sections.getOrDefault(y >> 4, null);
    }

    private StickySection getOrCreateSection(int y) {
        return this.sections.computeIfAbsent(y >> 4, k -> new StickySection(this));
    }

    public void attach(LevelChunk chunk) {
        this.chunk = chunk;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.sections.size());
        for (Map.Entry<Integer, StickySection> entry : this.sections.entrySet()) {
            buffer.writeVarInt(entry.getKey().intValue());
            entry.getValue().writeRawDataToBuffer(buffer);
        }
    }

    public void read(FriendlyByteBuf buffer) {
        int size = buffer.readVarInt();
        this.sections.clear();
        for (int i = 0; i < size; ++i) {
            int sectionId = buffer.readVarInt();
            StickySection section = new StickySection(this);
            section.readRawDataFromBuffer(buffer);
            this.sections.put(sectionId, section);
        }
    }

    public void loadFrom(StickyChunk networkChunk) {
        if (networkChunk.chunk != null) {
            throw new IllegalArgumentException("Can't copy data from attached chunk");
        }
        this.sections.clear();
        this.sections.putAll(networkChunk.sections);
        networkChunk.sections.clear();
    }

    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<Integer, StickySection> entry : this.sections.entrySet()) {
            if (entry.getValue().canBeDiscarded()) continue;
            tag.putByteArray(Integer.toString(entry.getKey()), entry.getValue().getStickies());
        }
        return tag;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @Nonnull CompoundTag nbt) {
        this.sections.clear();
        for (String key : nbt.getAllKeys()) {
            if (!nbt.contains(key, 7)) {
                UtilitiX.getInstance().logger.error("Invalid chunk section value in sticky chunk for: {}", (Object)key);
                continue;
            }
            try {
                int sectionId = Integer.parseInt(key);
                StickySection section = new StickySection(this);
                section.setStickies(nbt.getByteArray(key));
                this.sections.put(sectionId, section);
            }
            catch (NumberFormatException e) {
                UtilitiX.getInstance().logger.error("Invalid chunk section id in sticky chunk: {}", (Object)key);
            }
        }
    }

    public static interface ChunkAction {
        @Nullable
        public SectionAction section(int var1, int var2);
    }

    public static interface SectionAction {
        public void start();

        public void accept(int var1, int var2, int var3, byte var4);

        public void stop();
    }
}

